// DinoWorks UI Script 2020-05-04
$(document).ready(function(){
    //headerUI();
    //gnbUI();
    //buttonEffect();


});

// a[href="#"] 기본 동작 방지(상단 이동)
function preventDefaultAnchor() {
  $(document).on('click', 'a[href="#"]', function(e) {
    e.preventDefault();
  });
}


function setHeaderUI() {
  $('#header a.toggle').on('click', function() {
    $('body').toggleClass('close');
  });

  $('#header div.user a.user').on('click', function() {
    $('#header div.user').toggleClass('open');
  });
}


function setCurrentPage() {
  var bodyClass = $('body').attr('class');
  var classArray = bodyClass.split(' ');
  if (classArray[0] === 'main') return false;
  //console.log(classArray);

  // 타이틀 입력
  $('#gnb ul.nav a').each(function() {
    var content = $(this).text();
    $(this).attr({'title': content});
  });

  // 서브메뉴 유무 표시
  $('#gnb ul.nav > li').each(function() {
    if ($(this).find('ul').length > 0) {
      $(this).find('> a').append('<i class="fas fa-angle-right fa-fw"><span>서브메뉴 열림/닫힘</span></i>');
    }
  });

  $('#gnb h3').each(function() {
    if ($(this).attr('data-menu') === classArray[1]) {
      $(this).addClass('on');
      return false;
    }
  });

  $('#gnb h3.on + ul.nav > li').each(function() {
    if ($(this).attr('data-menu') === classArray[2]) {
      $(this).addClass('on');
      return false;
    }
  });

  $('#gnb ul.nav > li.on > ul > li').each(function() {
    if ($(this).attr('data-menu') === classArray[3]) {
      $(this).addClass('on');
      return false;
    }
  });
}


function setGNB() {
  var timerId = '';

  refresh();

  $('#gnb ul.nav > li > a').on('click', function() {
    if ($(this).parent().find('ul').length > 0) {
      var height = 0;
      $(this).next().find('> li').each(function() {
        height += $(this).outerHeight(true);
      });
      $('#gnb ul.nav > li > ul').css({'height': 0 + 'px'});
      $(this).next().css({'height': height + 'px'});
    }
  });

  $('#gnb').on('mouseleave', function() {
    timerId = setTimeout(function() {refresh();}, 500);
  }).on('mouseenter', function() {
    clearTimeout(timerId);
  });

  function refresh() {
    $('#gnb ul.nav > li:not(.on) > ul').css({'height': 0 + 'px'});
    if ($('#gnb ul.nav > li.on').find('ul').length > 0) {
      var height = 0;
      $('#gnb ul.nav > li.on > ul > li').each(function() {
        height += $(this).outerHeight(true);
      });
      $('#gnb ul.nav > li.on > ul').css({'height': height + 'px'});
    }
  }
}


function buttonEffect() {
  $(document).on('click', '.btn', function(e) {
    if ($(this).attr('class').indexOf('disabled') !== -1) {
      e.preventDefault();
      return false;
    }
    // 버튼 요소의 클릭된 자료 값 입력
    var coordX = e.clientX - $(this).offset().left + $(document).scrollLeft();
    var coordY = e.clientY - $(this).offset().top + $(document).scrollTop();
    //console.log(coordX + ' / ' + coordY);
    $(this).append('<span class="circle" style="left: ' + coordX + 'px; top: ' + coordY + 'px"></span>');
    $(this).find('span.circle:last').one('animationend', function() {
      $(this).remove();
    });
  });
}
