<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>대시보드(일반) | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 대시보드(일반) 페이지" />
  </head>
  <body class="sub dashboard-normal">
    <div id="wrapper">
      
      <%@ include file='../include/header.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>

        <section class="page-center">
          <div class="main-intro">
            <div>
              <h3>서비스 신청/관리</h3>
              <p>온라인으로 편하게 신청하고 관리해 보세요.</p>

              <div class="card icon on">
                <span class="image"><img alt="" src="/img/icon-pg.png" /></span>
                <em class="title">PG 서비스</em>
                <p class="button"><a href="#" class="btn small blue">신청하기</a></p>
              </div>

              <div class="card status">
                <span class="status">작성중</span>
                <p class="company"><em>(주)다우데이타</em>사업자등록번호 : 220-81-91773</p>
                <p class="button">
                  <a href="#" class="btn small red-line">삭제</a>
                  <a href="#" class="btn small blue">신청하기</a>
                </p>
              </div>

              <div class="card status">
                <span class="status green">심사중</span>
                <p class="company"><em>(주)다우데이타</em>사업자등록번호 : 220-81-91773</p>
                <p class="button">
                  <a href="#" class="btn small blue">신청서 확인</a>
                </p>
              </div>

              <div class="card status">
                <span class="status yellow">전자 계약중</span>
                <p class="company"><em>(주)다우데이타</em>사업자등록번호 : 220-81-91773</p>
                <p class="button">
                  <a href="#" class="btn small blue">신청서 확인</a>
                </p>
              </div>

              <div class="card status">
                <span class="status gray">계약 완료</span>
                <p class="company"><em>(주)다우데이타</em>사업자등록번호 : 220-81-91773</p>
                <p class="button">
                  <a href="#" class="btn small blue">신청서 확인</a>
                </p>
              </div>

              <div class="card status">
                <span class="status pink">추가고객확인</span>
                <p class="company"><em>(주)다우데이타</em>사업자등록번호 : 220-81-91773</p>
                <p class="button">
                  <a href="#" class="btn small blue-line">상세내용</a>
                  <a href="#" class="btn small blue">신청서 확인</a>
                </p>
              </div>

              <div class="card status">
                <span class="status pink">수정필요</span>
                <p class="company"><em>(주)다우데이타</em>사업자등록번호 : 220-81-91773</p>
                <p class="button">
                  <a href="#" class="btn small blue-line">상세내용</a>
                  <a href="#" class="btn small blue">신청서 확인</a>
                </p>
              </div>

              <div class="card status">
                <span class="status red">거래거절</span>
                <p class="company"><em>(주)다우데이타</em>사업자등록번호 : 220-81-91773</p>
                <p class="button">
                  <a href="#" class="btn small blue-line">상세내용</a>
                  <a href="#" class="btn small blue">신청서 확인</a>
                </p>
              </div>
            </div>

            <div>
              <h3>개발자센터</h3>
              <p>서비스 오픈 전 미리 개발 가이드를 확인해 보세요.</p>
              <div class="card icon on">
                <span class="image"><img alt="" src="/img/icon-guide.png" /></span>
                <em class="title">개발가이드</em>
                <p class="button"><a href="#" class="btn small blue">신청하기</a></p>
              </div>
            </div>

          </div>
        </section>
      </main>

      <div id="test-button">
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'success', title: '신청서 삭제', content: '진행중인 신청서를 삭제하시겠습니까?'}, this);">팝업창 1</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'success', title: '신청서 삭제', content: '거래거절 된 신청서입니다.<br />추가신청을 위해 삭제하시겠습니까?'}, this);">팝업창 2</a>
        <a href="#" class="btn small blue-line" onclick="showNext();">다음상태보기</a>
      </div>

    </div>

<script>
'use strict';

function showNext() {
  const cards = document.querySelectorAll('div.main-intro > div:nth-child(1) div.card');
  const numCards = cards.length;
  let onNow = 0;
  cards.forEach(function(card, i) {
    if (card.classList.contains('on') === true) onNow = i;
    card.classList.remove('on');
  });
  onNow = (onNow + 1) >= numCards ? 0 : onNow + 1;
  // console.log(numCards, onNow);
  cards[onNow].classList.add('on');
}






</script>


  </body>
</html>