<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>회원가입 | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 회원가입 페이지" />
  </head>
  <body class="sub join">
    <div id="wrapper">
      
      <%@ include file='../include/header-no-login.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>

        <h2>회원가입</h2>

        <section class="content">
          <h3 class="title">회원을 선택해주세요. (대행회원은 키움페이 파트너입니다.)</h3>
          <ul class="input-list">
            <li><input type="radio" name="user_type" id="user-type-1" checked="checked" /><label for="user-type-1">일반회원</label></li>
            <li><input type="radio" name="user_type" id="user-type-2" /><label for="user-type-2">대행회원</label></li>
          </ul>
        </section>

        <section class="content option">
          <h3 class="ir-hidden">일반회원 입력 폼</h3>
          <ul class="form two-column">
            <li>
              <div class="form-box">
                <label for="user-name">이름</label>
                <input type="text" name="" id="user-name" class="text" placeholder="" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="user-email">이메일</label>
                <input type="text" name="" id="user-email" class="text" placeholder="" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="user-pw">비밀번호</label>
                <input type="password" name="" id="user-pw" class="text" placeholder="(8자리 이상 20자 이하의 문자/숫자/기호 조합)" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="user-pw-confirm">비밀번호 확인</label>
                <input type="password" name="" id="user-pw-confirm" class="text" placeholder="" value="" />
              </div>
            </li>
            <li>
              <div class="form-box button">
                <label for="user-mobile">휴대폰 번호</label>
                <input type="text" name="" id="user-mobile" class="text" placeholder="" value="" />
                <a href="#" class="btn regular blue disabled">인증요청</a>
              </div>
            </li>
            <li>
              <div class="form-box button">
                <label for="cert-key">인증번호</label>
                <input type="text" name="" id="cert-key" class="text" placeholder="" value="" />
                <a href="#" class="btn regular blue disabled">인증하기</a>
                <span id="timer1" class="timer"><span>유효 시간</span><em>3:00</em></span>
              </div>
            </li>
            <li class="full">
              <p class="checkbox"><input type="checkbox" name="" id="info-agree" /><label for="info-agree">[필수] 개인정보 수집 및 이용 동의</label></p>
            </li>
            <li class="btn full">
              <a href="#" id="register1" class="btn regular blue full disabled">가입</a>
              <!-- 'disabled' 클래스 제거시 일반 버튼으로 표시됨 -->
            </li>
          </ul>
        </section>

        <section class="content option hidden">
          <h3 class="ir-hidden">대행회원 입력 폼</h3>
          <ul class="form two-column">
            <li>
              <div class="form-box">
                <label for="user-name2">이름</label>
                <input type="text" name="" id="user-name2" class="text" placeholder="" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="user-email2">이메일</label>
                <input type="text" name="" id="user-email2" class="text" placeholder="" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="user-pw2">비밀번호</label>
                <input type="password" name="" id="user-pw2" class="text" placeholder="(8자리 이상 20자 이하의 문자/숫자/기호 조합)" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="user-pw-confirm2">비밀번호 확인</label>
                <input type="password" name="" id="user-pw-confirm2" class="text" placeholder="" value="" />
              </div>
            </li>
            <li>
              <div class="form-box button">
                <label for="user-mobile2">휴대폰 번호</label>
                <input type="text" name="" id="user-mobile2" class="text" placeholder="" value="" />
                <a href="#" class="btn regular blue disabled">인증요청</a>
              </div>
            </li>
            <li>
              <div class="form-box button">
                <label for="cert-key2">인증번호</label>
                <input type="text" name="" id="cert-key2" class="text" placeholder="" value="" />
                <a href="#" class="btn regular blue disabled">인증하기</a>
                <span id="timer2" class="timer"><span>유효 시간</span><em>3:00</em></span>
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="corp-num">사업자번호</label>
                <input type="text" name="" id="corp-num" class="text" placeholder="" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="corp-name">사업자명</label>
                <input type="text" name="" id="corp-name" class="text" placeholder="" value="" />
              </div>
            </li>
            <li>
              <div class="form-box button">
                <label for="admin-id">관리자 페이지 로그인 ID</label>
                <input type="text" name="" id="admin-id" class="text" placeholder="" value="" />
                <a href="#" class="btn regular blue disabled">조회</a>
              </div>
            </li>
            <li class="full">
              <p class="checkbox"><input type="checkbox" name="" id="info-agree2" /><label for="info-agree2">[필수] 개인정보 수집 및 이용 동의</label></p>
            </li>
            <li class="btn full">
              <a href="#" id="register2" class="btn regular blue full disabled">가입</a>
            </li>
          </ul>
        </section>
      </main>


      <div id="test-button">
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'confirm', title: '인증번호 발송 확인', content: '입력하신 휴대폰 번호로<br />인증번호를 발송했습니다.', buttons: ['닫기', '설정하기']}, this);">팝업창1</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'confirm', title: '인증번호 발송 확인', content: '입력하신 휴대폰 번호로<br />인증번호를 발송했습니다.', buttons: ['닫기']}, this);">팝업창1-1</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'success', title: '인증번호 발송', content: '입력하신 휴대폰 번호로<br />인증번호를 발송했습니다.'}, this);">팝업창2</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'fail', title: '인증번호 누락', content: '[KIWOOMPAY] 번호 인증을 위해<br />[000000]를 입력해주세요.'}, this);">팝업창3</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'success', title: '회원가입 완료', content: '가입을 축하 드립니다.<br />가입한 정보로 로그인 해주세요.'}, this);">팝업창4</a>
        <a href="#" class="btn small blue-line" onclick="showLayerPopup('#layer-regulation', this);">팝업창5</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'fail', title: '관리자 페이지 정보 오류', content: '키움페이 관리자 페이지<br />로그인 정보를 확인해주세요.'}, this);">팝업창6</a>
        <a href="#" class="btn small blue-line" onclick="enableButton('#register1');">버튼 활성화</a>
        <a href="#" class="btn small blue-line" onclick="disableButton('#register1');">버튼 비활성화</a>
        <a href="#" class="btn small blue-line" onclick="startTimer(3, 'timer1');">타이머시작</a>
        <a href="#" class="btn small blue-line" onclick="stopTimer('timer1');">타이머중지</a>
      </div>
    </div>   <!-- #wrapper -->

    <div id="layer-regulation">
      <div class="container">
        <h3>개인정보 수집 및 이용동의</h3>
        <p>다우데이타(이하 회사라 함)는 "신용정보의 이용 및 보호에 관한 법률", "전자금융거래법", "전자상거래 등에서의 소비자보호에 관한 법률", "정보통신망 이용촉진 및 정보보호 등에 관한 법률" 및 "개인정보 보호법" 등 관련 법령을 준수하여, 이용자 권익 보호에 최선을 다하고 있습니다.</p>
        
        <h4>1. 개인정보의 수집·이용 목적</h4>
        <p>홈페이지 서비스 이용을 위한 사용자 식별 및 가맹점 정보 접근권한 관리<br />홈페이지 이용에 대한 문의 및 불만사항 접수, 회신<br />홈페이지 이용빈도 파악 및 통계 활용 ※ 회사는 개인정보를 위의 목적으로 처리하며, 동의받은 목적 이외의 용도로 처리하지 않습니다.</p>
        <h4>2. 수집·이용하는 개인정보 항목</h4>
        <p>성명, 이메일주소, 비밀번호, 휴대폰번호</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
      </div>
      <p class="button"><a href="#" class="close">닫기</a></p>
    </div>

<script>
'use strict';

setUserType();

function setUserType() {
  const options = document.querySelectorAll('section.option');

  checkUserType();
  document.querySelectorAll('[name="user_type"]').forEach(function(radio) {
    radio.addEventListener('change', function() {
      checkUserType();
    }, false);
  });

  function checkUserType() {
    options.forEach(function(option) {
      option.classList.add('hidden');
    });

    document.querySelectorAll('[name="user_type"]').forEach(function(radio, i) {
      if (radio.checked === true) {
        options[i].classList.remove('hidden');
      }
    });
  }
}



// startTimer(3);
let timer = null;

function startTimer(setMin, id) {
  let min = setMin;
  let sec = 0;
  let time = min * 60;
  const Timer = document.querySelector('#' + id);
  const timerText = document.querySelector('#' + id + ' em');
  document.querySelector('#' + id).style.display = 'block';

  displayTimer();
  timer = setInterval(function() {
    displayTimer();

    if (time < 0) {
      stopTimer(id);
      alert('finish');
    }
  }, 1000);

  function displayTimer() {
    let min = Math.floor(time / 60);
    let sec = time - (min * 60);
    let displayTime = min + ':' + String(sec).padStart(2, '0');
    timerText.innerText = displayTime;
    time--;
  }
}

// stopTimer();
function stopTimer(id) {
  clearTimeout(timer);
  const Timer = document.querySelector('#' + id);
  Timer.style.display = 'none';
}


</script>

  </body>
</html>