<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>마이페이지 | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 마이페이지" />
  </head>
  <body class="sub mypage">
    <div id="wrapper">
      
      <%@ include file='../include/header.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>
        
        <h2>마이페이지</h2>

        <section class="content">
          <ul class="form two-column">
            <li>
              <div class="form-box">
                <label for="user-id">아이디</label>
                <input type="text" name="" id="user-id" class="text" placeholder="" value="hakim@daoudata.co.kr" disabled="disabled" />
              </div>
            </li>
            <li>

            </li>
            <li>
              <div class="form-box button">
                <label for="user-name">이름</label>
                <input type="text" name="" id="user-name" class="text" placeholder="" value="" />
                <a href="#" id="change1" class="btn regular blue disabled">변경하기</a>
              </div>
            </li>
            <li>
              <div class="form-box button">
                <label for="user-pw">비밀번호</label>
                <input type="password" name="" id="user-pw" class="text" placeholder="" value="" />
                <a href="#" class="btn regular blue disabled">변경하기</a>
              </div>
            </li>
            <li>
              <div class="form-box button">
                <label for="user-mobile">휴대폰 번호</label>
                <input type="text" name="" id="user-mobile" class="text" placeholder="" value="" />
                <a href="#" class="btn regular blue disabled">인증요청</a>
              </div>
            </li>
            <li>
              <div class="form-box button">
                <label for="cert-key">인증번호</label>
                <input type="text" name="" id="cert-key" class="text" placeholder="" value="" />
                <a href="#" class="btn regular blue disabled">인증요청</a>
              </div>
            </li>
            <li class="option hidden">
              <div class="form-box button">
                <label for="user-email">이메일</label>
                <input type="text" name="" id="user-email" class="text" placeholder="" value="" />
                <a href="#" class="btn regular blue disabled">인증요청</a>
              </div>
            </li>
          </ul>
        </section>

        <p class="page-button"><a href="#">hakim@daoudata.co.kr 계정을 삭제하시겠습니까?</a></p>
      </main>

      <div id="test-button">
        <a href="#" class="btn small blue-line" onclick="enableButton('#change1');">버튼 활성화</a>
        <a href="#" class="btn small blue-line" onclick="disableButton('#change1');">버튼 비활성화</a>
        <a href="#" class="btn small blue-line" onclick="displayFormError('#cert-key', '인증번호가 다릅니다. 이메일로 인증해주세요.');">폼 오류표시</a>
        <a href="#" class="btn small blue-line" onclick="resetFormError('#cert-key');">폼 초기화</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'success', title: '변경 완료', content: '이름이 정상적으로 변경 되었습니다.'}, this);">팝업창1</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'success', title: '인증번호 발송', content: '입력하신 이메일 및 휴대폰 번호로<br />인증번호를 발송했습니다.'}, this);">팝업창2</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'confirm', title: '계정삭제', content: '정말로 계정을 삭제하시겠습니까?<br />(삭제 시, 신청 정보도 함께 삭제됩니다.)', buttons: ['닫기', '삭제하기']}, this);">팝업창3</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'fail', title: '계정삭제', content: '정말로 계정을 삭제하시겠습니까?<br />(삭제 시, 신청 정보도 함께 삭제됩니다.)'}, this);">팝업창4</a>
        <a href="#" class="btn small blue-line" onclick="setFormVisibility('ul.form > li.option', 'show');">이메일 표시</a>
        <a href="#" class="btn small blue-line" onclick="setFormVisibility('ul.form > li.option', 'hide');">이메일 숨김</a>
      </div>
    </div>   <!-- #wrapper -->

<script>
'use strict';






</script>

  </body>
</html>