<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>비밀번호 찾기 | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 비밀번호 찾기 페이지" />
  </head>
  <body class="sub password-find">
    <div id="wrapper">
      
      <%@ include file='../include/header-no-login.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>

        <h2>비밀번호 찾기</h2>

        <section class="content">
          <h3 class="title">가입 당시 이메일과 휴대폰 번호를 입력해주세요.</h3>
          
          <ul class="form two-column">
            <li>
              <div class="form-box">
                <label for="user-name">이메일</label>
                <input type="text" name="" id="user-name" class="text" placeholder="" value="" />
              </div>
            </li>
            <li>

            </li>
            <li>
              <div class="form-box button">
                <label for="user-mobile">휴대폰 번호</label>
                <input type="text" name="" id="user-mobile" class="text" placeholder="" value="" />
                <a href="#" class="btn regular blue disabled">인증요청</a>
              </div>
            </li>
            <li>
              <div class="form-box button">
                <label for="cert-key">인증번호</label>
                <input type="text" name="" id="cert-key" class="text" placeholder="" value="" />
                <a href="#" class="btn regular blue disabled">인증요청</a>
                <span id="timer1" class="timer"><span>유효 시간</span><em>3:00</em></span>
              </div>
            </li>
            <li class="btn full">
              <a href="#" id="pw-find" class="btn regular blue full disabled">비밀번호 찾기</a>
            </li>
          </ul>
          <p class="page-option"><a href="#">이메일로 인증번호 받기</a></p>
        </section>
      </main>


      <div id="test-button">
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'success', title: '인증번호 발송', content: '입력하신 휴대폰 번호로<br />인증번호를 발송했습니다.'}, this);">팝업창1</a>
        <a href="#" class="btn small blue-line" onclick="enableButton('#pw-find');">버튼 활성화</a>
        <a href="#" class="btn small blue-line" onclick="disableButton('#pw-find');">버튼 비활성화</a>
        <a href="#" class="btn small blue-line" onclick="startTimer(3, 'timer1');">타이머시작</a>
        <a href="#" class="btn small blue-line" onclick="stopTimer('timer1');">타이머중지</a>
        <a href="#" class="btn small blue-line" onclick="showEmailCert();">이메일인증표시</a>
        <a href="#" class="btn small blue-line" onclick="hideEmailCert();">이메일인증숨김</a>
      </div>
    </div>   <!-- #wrapper -->

<script>
'use strict';

// startTimer(3);
let timer = null;

function startTimer(setMin, id) {
  let min = setMin;
  let sec = 0;
  let time = min * 60;
  const Timer = document.querySelector('#' + id);
  const timerText = document.querySelector('#' + id + ' em');
  document.querySelector('#' + id).style.display = 'block';

  displayTimer();
  timer = setInterval(function() {
    displayTimer();

    if (time < 0) {
      stopTimer(id);
      alert('finish');
    }
  }, 1000);

  function displayTimer() {
    let min = Math.floor(time / 60);
    let sec = time - (min * 60);
    let displayTime = min + ':' + String(sec).padStart(2, '0');
    timerText.innerText = displayTime;
    time--;
  }
}

// stopTimer();
function stopTimer(id) {
  clearTimeout(timer);
  const Timer = document.querySelector('#' + id);
  Timer.style.display = 'none';
}


function showEmailCert() {
  document.querySelector('p.page-option').style.display = 'block';
}

function hideEmailCert() {
  document.querySelector('p.page-option').style.display = 'none';
}

</script>

  </body>
</html>