<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>뷰페이지(CDD/법인) | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 뷰페이지(CDD/법인) 페이지" />
  </head>
  <body class="sub viewpage-cdd-corp">
    <div id="wrapper">
      
      <%@ include file='../include/header.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>

        <h2><span class="before">다우데이타 220-23-10388 님이</span>제출해주신 가맹점 정보입니다.</h2>

        <section class="content">
          <section class="fold open">
            <h3><a href="#">기본정보</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="basic-01">가맹점 구분</label>
                  <input type="text" name="" id="basic-01" class="text" placeholder="" value="법인사업자" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="basic-02">신탁구분</label>
                  <input type="text" name="" id="basic-02" class="text" placeholder="" value="해당사항 없음" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="basic-03">가상자산사업자 여부</label>
                  <input type="text" name="" id="basic-03" class="text" placeholder="" value="아니오" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">사업자 정보</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="business-01">사업자번호</label>
                  <input type="text" name="" id="business-01" class="text" placeholder="" value="220-81-01733" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-22">법인등록번호</label>
                  <input type="text" name="" id="business-22" class="text" placeholder="" value="1238751-11120765" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-02">상호명(국문)</label>
                  <input type="text" name="" id="business-02" class="text" placeholder="" value="다우데이타" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-03">상호명(영문)</label>
                  <input type="text" name="" id="business-03" class="text" placeholder="" value="DAOUDATA" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-04">업종</label>
                  <input type="text" name="" id="business-04" class="text" placeholder="" value="전자지급결제대행" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-05">업태</label>
                  <input type="text" name="" id="business-05" class="text" placeholder="" value="금융 및 보험업" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-06">과세 구분</label>
                  <input type="text" name="" id="business-06" class="text" placeholder="" value="복합과세" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-07">표준산업분류코드</label>
                  <input type="text" name="" id="business-07" class="text" placeholder="" value="66209" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-08">서비스(사이트명)</label>
                  <input type="text" name="" id="business-08" class="text" placeholder="" value="뿌리오" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-09">사이트 주소 (URL)</label>
                  <input type="text" name="" id="business-09" class="text" placeholder="" value="kiwoompay.co.kr" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-10">회사 전화번호</label>
                  <input type="text" name="" id="business-10" class="text" placeholder="" value="1588-5984" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-11">회사 이메일</label>
                  <input type="text" name="" id="business-11" class="text" placeholder="" value="help@kiwoompay.co.kr" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-12">개업 연월일</label>
                  <input type="text" name="" id="business-12" class="text" placeholder="" value="1992.07.01" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-13">대표자 형태</label>
                  <input type="text" name="" id="business-13" class="text" placeholder="" value="단독대표" />
                </div>
              </li>
              <li class="full">
                <div class="form-box">
                  <label for="business-14-1">사업장 소재지</label>
                  <input type="text" name="" id="business-14-1" class="text short" placeholder="국가명" title="국가명" value="대한민국" />
                  <input type="text" name="" id="business-14-2" class="text" placeholder="" title="상세주소"  value="(04156) 서울 마포구 독막로 311, 5층 (염리동, 재화스퀘어)" />
                </div>
              </li>
              <li class="full">
                <div class="form-box">
                  <label for="business-15-1">본점 소재지</label>
                  <input type="text" name="" id="business-15-1" class="text short" placeholder="국가명" title="국가명" value="대한민국" />
                  <input type="text" name="" id="business-15-2" class="text" placeholder=" "title="상세주소" value="(04156) 서울 마포구 독막로 311, 5층 (염리동, 재화스퀘어)" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">대표자 정보 1</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="ceo-01">대표자명</label>
                  <input type="text" name="" id="ceo-01" class="text" placeholder="" value="성백진" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo-02">대표자 영문명</label>
                  <input type="text" name="" id="ceo-02" class="text" placeholder="" value="Seong beak jin" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo-03">휴대폰 번호</label>
                  <input type="text" name="" id="ceo-03" class="text" placeholder="" value="010-2334-1234" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo-04">이메일</label>
                  <input type="text" name="" id="ceo-04" class="text" placeholder="" value="bjseong@daoudata.co.kr" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo-05">대표자 국적</label>
                  <input type="text" name="" id="ceo-05" class="text" placeholder="" value="대한민국" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo-06">거주 국가</label>
                  <input type="text" name="" id="ceo-06" class="text" placeholder="" value="대한민국" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo-07">대표자 생년월일</label>
                  <input type="text" name="" id="ceo-07" class="text" placeholder="" value="1970.01.01" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo-08">성별</label>
                  <input type="text" name="" id="ceo-08" class="text" placeholder="" value="남" />
                </div>
              </li>
              <li class="full">
                <div class="form-box">
                  <label for="ceo-09">주소</label>
                  <input type="text" name="" id="ceo-09" class="text" placeholder="" value="(04156) 서울 마포구 독막로 311, 5층 (염리동, 재화스퀘어)" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">대표자 정보 2</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="ceo2-01">대표자명</label>
                  <input type="text" name="" id="ceo2-01" class="text" placeholder="" value="성백진" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo2-02">대표자 영문명</label>
                  <input type="text" name="" id="ceo2-02" class="text" placeholder="" value="Seong beak jin" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo2-03">휴대폰 번호</label>
                  <input type="text" name="" id="ceo2-03" class="text" placeholder="" value="010-2334-1234" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo2-04">이메일</label>
                  <input type="text" name="" id="ceo2-04" class="text" placeholder="" value="bjseong@daoudata.co.kr" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo2-05">대표자 국적</label>
                  <input type="text" name="" id="ceo2-05" class="text" placeholder="" value="대한민국" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo2-06">거주 국가</label>
                  <input type="text" name="" id="ceo2-06" class="text" placeholder="" value="대한민국" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo2-07">대표자 생년월일</label>
                  <input type="text" name="" id="ceo2-07" class="text" placeholder="" value="1970.01.01" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo2-08">성별</label>
                  <input type="text" name="" id="ceo2-08" class="text" placeholder="" value="남" />
                </div>
              </li>
              <li class="full">
                <div class="form-box">
                  <label for="ceo2-09">주소</label>
                  <input type="text" name="" id="ceo2-09" class="text" placeholder="" value="(04156) 서울 마포구 독막로 311, 5층 (염리동, 재화스퀘어)" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">실제소유자 정보 1</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="owner-11">실제소유자 확인생략대상</label>
                  <input type="text" name="" id="owner-11" class="text" placeholder="" value="해당 없음" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="owner-12">실제소유자 확인 단계</label>
                  <input type="text" name="" id="owner-12" class="text" placeholder="" value="2단계" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="owner-01">실제소유자명</label>
                  <input type="text" name="" id="owner-01" class="text" placeholder="" value="김실제" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="owner-02">실제소유자 영문명</label>
                  <input type="text" name="" id="owner-02" class="text" placeholder="" value="Kim siljae" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="owner-03">실제소유자 국적</label>
                  <input type="text" name="" id="owner-03" class="text" placeholder="" value="대한민국" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="owner-04">실제소유자 생년월일</label>
                  <input type="text" name="" id="owner-04" class="text" placeholder="" value="1996.06.23" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="owner-05">실제소유자 지분율 (%)</label>
                  <input type="text" name="" id="owner-05" class="text" placeholder="" value="25%" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">대리인 정보</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="rep-01">대리인명</label>
                  <input type="text" name="" id="rep-01" class="text" placeholder="" value="한선호" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="rep-02">대리인 영문명</label>
                  <input type="text" name="" id="rep-02" class="text" placeholder="" value="Han sun ho" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="rep-03">대리인 국적</label>
                  <input type="text" name="" id="rep-03" class="text" placeholder="" value="대한민국" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="rep-04">대리인 생년월일</label>
                  <input type="text" name="" id="rep-04" class="text" placeholder="" value="1996.03.21" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="rep-05">휴대폰 번호</label>
                  <input type="text" name="" id="rep-05" class="text" placeholder="" value="010-2123-1231" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="rep-06">이메일</label>
                  <input type="text" name="" id="rep-06" class="text" placeholder="" value="shhan@daoudata.co.kr" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="rep-07">신청인과의 관계</label>
                  <input type="text" name="" id="rep-07" class="text" placeholder="" value="직원" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="rep-08">성별</label>
                  <input type="text" name="" id="rep-08" class="text" placeholder="" value="여" />
                </div>
              </li>
              <li class="full">
                <div class="form-box">
                  <label for="rep-09">주소</label>
                  <input type="text" name="" id="rep-09" class="text" placeholder="" value="(04156) 서울 마포구 독막로 311, 5층 (염리동, 재화스퀘어)" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">정산 계좌정보</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="account-01">은행명</label>
                  <input type="text" name="" id="account-01" class="text" placeholder="" value="국민" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="account-02">예금주</label>
                  <input type="text" name="" id="account-02" class="text" placeholder="" value="다우데이타" />
                </div>
              </li>
              <li class="full">
                <div class="form-box">
                  <label for="account-03">계좌번호</label>
                  <input type="text" name="" id="account-03" class="text" placeholder="" value="087-23-0086-087" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">첨부파일</a></h3>
            <ul class="file-download">
              <li>
                <span class="label">사업자 등록증 사본</span>
                <ul class="file">
                  <li><span>(주)다우데이타 사업자 등록증.jpg</span><a href="#">다운로드</a></li>
                </ul>
              </li>
              <li>
                <span class="label">대표자 신분증 사본</span>
                <ul class="file">
                  <li><span>다우데이타 대표자 성백진 신분증 사본.pdf</span><a href="#">다운로드</a></li>
                  <li><span>다우데이타 대표자 성백진 신분증 사본.pdf</span><a href="#">다운로드</a></li>
                </ul>
              </li>
              <li>
                <span class="label">법인 인감증명서</span>
                <ul class="file">
                  <li><span>다우데이타 법인인감증명서 사본.pdf</span><a href="#">다운로드</a></li>
                </ul>
              </li>
              <li>
                <span class="label">법인 등기부등본</span>
                <ul class="file">
                  <li><span>다우데이타 법인등기부등본 사본.pdf</span><a href="#">다운로드</a></li>
                </ul>
              </li>
              <li>
                <span class="label">주주명부 / 주주명부확인서</span>
                <ul class="file">
                  <li><span>다우데이타 주주명부 사본.pdf</span><a href="#">다운로드</a></li>
                </ul>
              </li>
              <li>
                <span class="label">대리인 위임장</span>
                <ul class="file">
                  <li><span>다우데이타 대리인위임장.pdf</span><a href="#">다운로드</a></li>
                </ul>
              </li>
              <li>
                <span class="label">대리인 신분증 사본</span>
                <ul class="file">
                  <li><span>다우데이타 대리인 신분증 사본.jpg</span><a href="#">다운로드</a></li>
                </ul>
              </li>
              <li>
                <span class="label">실제소유자 증명서류</span>
                <ul class="file">
                  <li><span>다우데이타 실제소유자 증명서류 사본.pdf</span><a href="#">다운로드</a></li>
                </ul>
              </li>
              <li>
                <span class="label">설립목적 검증 서류</span>
                <ul class="file">
                  <li><span>검증서류.pdf</span><a href="#">다운로드</a></li>
                </ul>
              </li>
            </ul>
          </section>

          <div class="button-box">
            <a href="#" class="btn regular blue-line left">이전</a>
            <a href="#" class="btn regular blue">다음</a>
          </div>
        </section>
      </main>

    </div>   <!-- #wrapper -->

<script>
'use strict';

setSectionFold();

function setSectionFold() {
  const sections = document.querySelectorAll('section.fold');
  const sectionHeader = document.querySelectorAll('section.fold h3 a');

  sectionHeader.forEach(function(header) {
    header.addEventListener('click', function() {
      const that = this;
      this.closest('section').classList.toggle('open');
    }, false);
  });
}





</script>

  </body>
</html>