<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>뷰페이지(CDD/개인) | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 뷰페이지(CDD/개인) 페이지" />
  </head>
  <body class="sub viewpage-cdd-private">
    <div id="wrapper">
      
      <%@ include file='../include/header.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>

        <h2><span class="before">다우데이타 220-23-10388 님이</span>제출해주신 가맹점 정보입니다.</h2>

        <section class="content">
          <section class="fold open">
            <h3><a href="#">기본정보</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="basic-01">가맹점 구분</label>
                  <input type="text" name="" id="basic-01" class="text" placeholder="" value="개인사업자" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="basic-02">신탁구분</label>
                  <input type="text" name="" id="basic-02" class="text" placeholder="" value="해당사항없음" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="basic-03">가상자산사업자 여부</label>
                  <input type="text" name="" id="basic-03" class="text" placeholder="" value="아니오" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">사업자 정보</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="business-01">사업자번호</label>
                  <input type="text" name="" id="business-01" class="text" placeholder="" value="220-81-01733" />
                </div>
              </li>
              <li></li>
              <li>
                <div class="form-box">
                  <label for="business-02">상호명(국문)</label>
                  <input type="text" name="" id="business-02" class="text" placeholder="" value="다우데이타" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-03">상호명(영문)</label>
                  <input type="text" name="" id="business-03" class="text" placeholder="" value="DAOUDATA" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-04">업종</label>
                  <input type="text" name="" id="business-04" class="text" placeholder="" value="전자지급결제대행" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-05">업태</label>
                  <input type="text" name="" id="business-05" class="text" placeholder="" value="금융 및 보험업" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-06">과세 구분</label>
                  <input type="text" name="" id="business-06" class="text" placeholder="" value="복합과세" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-07">표준산업분류코드</label>
                  <input type="text" name="" id="business-07" class="text" placeholder="" value="66209" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-08">서비스(사이트명)</label>
                  <input type="text" name="" id="business-08" class="text" placeholder="" value="뿌리오" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-09">사이트 주소 (URL)</label>
                  <input type="text" name="" id="business-09" class="text" placeholder="" value="kiwoompay.co.kr" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-10">회사 전화번호</label>
                  <input type="text" name="" id="business-10" class="text" placeholder="" value="1588-5984" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-11">회사 이메일</label>
                  <input type="text" name="" id="business-11" class="text" placeholder="" value="help@kiwoompay.co.kr" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-12">개업 연월일</label>
                  <input type="text" name="" id="business-12" class="text" placeholder="" value="1992.07.01" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="business-13">대표자 형태</label>
                  <input type="text" name="" id="business-13" class="text" placeholder="" value="단독대표" />
                </div>
              </li>
              <li class="full">
                <div class="form-box">
                  <label for="business-14-1">사업장 소재지</label>
                  <input type="text" name="" id="business-14-1" class="text short" placeholder="국가명" title="국가명" value="대한민국" />
                  <input type="text" name="" id="business-14-2" class="text" placeholder="" title="상세주소" value="(04156) 서울 마포구 독막로 311, 5층 (염리동, 재화스퀘어)" />
                </div>
              </li>
              <li class="full">
                <div class="form-box">
                  <label for="business-15-1">본점 소재지</label>
                  <input type="text" name="" id="business-15-1" class="text short" placeholder="국가명" title="국가명" value="대한민국" />
                  <input type="text" name="" id="business-15-2" class="text" placeholder="" title="상세주소" value="(04156) 서울 마포구 독막로 311, 5층 (염리동, 재화스퀘어)" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">대표자 정보 1</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="ceo-01">대표자명</label>
                  <input type="text" name="" id="ceo-01" class="text" placeholder="" value="성백진" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo-02">대표자 영문명</label>
                  <input type="text" name="" id="ceo-02" class="text" placeholder="" value="Seong beak jin" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo-03">휴대폰 번호</label>
                  <input type="text" name="" id="ceo-03" class="text" placeholder="" value="010-2334-1234" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo-04">이메일</label>
                  <input type="text" name="" id="ceo-04" class="text" placeholder="" value="bjseong@daoudata.co.kr" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo-05">대표자 국적</label>
                  <input type="text" name="" id="ceo-05" class="text" placeholder="" value="대한민국" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo-06">거주 국가</label>
                  <input type="text" name="" id="ceo-06" class="text" placeholder="" value="대한민국" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo-07">대표자 생년월일</label>
                  <input type="text" name="" id="ceo-07" class="text" placeholder="" value="1970.01.01" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo-08">성별</label>
                  <input type="text" name="" id="ceo-08" class="text" placeholder="" value="남" />
                </div>
              </li>
              <li class="full">
                <div class="form-box">
                  <label for="ceo-09">주소</label>
                  <input type="text" name="" id="ceo-09" class="text" placeholder="" value="(04156) 서울 마포구 독막로 311, 5층 (염리동, 재화스퀘어)" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">실제소유자 정보 1</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="owner-01">실제소유자명</label>
                  <input type="text" name="" id="owner-01" class="text" placeholder="" value="김실제" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="owner-02">실제소유자 영문명</label>
                  <input type="text" name="" id="owner-02" class="text" placeholder="" value="Kim siljae" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="owner-03">실제소유자 국적</label>
                  <input type="text" name="" id="owner-03" class="text" placeholder="" value="대한민국" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="owner-04">실명번호</label>
                  <input type="text" name="" id="owner-04" class="text" placeholder="" value="900101-1234876" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">정산 계좌정보</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="account-01">은행명</label>
                  <input type="text" name="" id="account-01" class="text" placeholder="" value="국민" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="account-02">예금주</label>
                  <input type="text" name="" id="account-02" class="text" placeholder="" value="다우데이타" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="account-03">계좌번호</label>
                  <input type="text" name="" id="account-03" class="text" placeholder="" value="087-23-0086-087" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="account-04">세금계산서 수신 이메일</label>
                  <input type="text" name="" id="account-04" class="text" placeholder="" value="account@daoudata.co.kr" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">첨부파일</a></h3>
            <ul class="file-download">
              <li>
                <span class="label">사업자 등록증 사본</span>
                <ul class="file">
                  <li><span>(주)다우데이타 사업자 등록증.jpg</span><a href="#">다운로드</a></li>
                </ul>
              </li>
              <li>
                <span class="label">통장 사본</span>
                <ul class="file">
                  <li><span>(주)다우데이타 통장사본.pdf</span><a href="#">다운로드</a></li>
                  <li><span>추가된 통장사본.jpg</span><a href="#">다운로드</a></li>
                </ul>
              </li>
              <li>
                <span class="label">대표자 신분증 사본 대표자 신분증 사본</span>
                <ul class="file">
                  <li><span>다우데이타 대표자 신분증 사본 다우데이타 대표자 신분증 사본 다우데이타 대표자 신분증 사본.jpg</span><a href="#">다운로드</a></li>
                </ul>
              </li>
              <li>
                <span class="label">개인 인감증명서</span>
                <ul class="file">
                  <li><span>다우데이타 개인인감증명서 사본.jpg</span><a href="#">다운로드</a></li>
                </ul>
              </li>
              <li>
                <span class="label">실제소유자 신분증 사본</span>
                <ul class="file">
                  <li><span>다우데이타 실제소유자 신분증 사본.jpg</span><a href="#">다운로드</a></li>
                </ul>
              </li>
            </ul>
          </section>

          <div class="button-box">
            <a href="#" class="btn regular blue-line left">이전</a>
            <a href="#" class="btn regular blue">다음</a>
          </div>
        </section>
      </main>

    </div>   <!-- #wrapper -->

<script>
'use strict';

setSectionFold();

function setSectionFold() {
  const sections = document.querySelectorAll('section.fold');
  const sectionHeader = document.querySelectorAll('section.fold h3 a');

  sectionHeader.forEach(function(header) {
    header.addEventListener('click', function() {
      const that = this;
      this.closest('section').classList.toggle('open');
    }, false);
  });
}





</script>

  </body>
</html>