<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>뷰페이지(EDD/법인) | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 뷰페이지(EDD/법인) 페이지" />
  </head>
  <body class="sub viewpage-edd-corp">
    <div id="wrapper">
      
      <%@ include file='../include/header.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>

        <h2><span class="before">다우데이타 220-23-10388 님이</span>제출해주신 가맹점 정보입니다.</h2>

        <section class="content">
          <section class="fold open">
            <h3><a href="#">기본정보</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="basic-01">가맹점 구분</label>
                  <input type="text" name="" id="basic-01" class="text" placeholder="" value="법인사업자" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="basic-02">거래 목적</label>
                  <input type="text" name="" id="basic-02" class="text" placeholder="" value="사업상 거래" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="basic-03">거래자금의 원천 및 출처</label>
                  <input type="text" name="" id="basic-03" class="text" placeholder="" value="근로 및 연금소득" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">주요 거래 정보</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="transaction-01">거래대상</label>
                  <input type="text" name="" id="transaction-01" class="text" placeholder="" value="의료품 납품" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="transaction-02">예상 거래 횟수 (월)</label>
                  <input type="text" name="" id="transaction-02" class="text" placeholder="" value="250회" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="transaction-03">거래금액 (월)</label>
                  <input type="text" name="" id="transaction-03" class="text" placeholder="" value="250,000,000" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">가맹점 추가 정보</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="add-01">법인유형</label>
                  <input type="text" name="" id="add-01" class="text" placeholder="" value="중견기업" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="add-02">직원수 (명)</label>
                  <input type="text" name="" id="add-02" class="text" placeholder="" value="200" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="add-03">상장여부</label>
                  <input type="text" name="" id="add-03" class="text" placeholder="" value="아니오" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="add-04">거래소</label>
                  <input type="text" name="" id="add-04" class="text" placeholder="" readonly="readonly" value="" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="add-05">회사 주요 상품 / 서비스</label>
                  <input type="text" name="" id="add-05" class="text" placeholder="" value="소프트웨어" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="add-06">주요 거래처</label>
                  <input type="text" name="" id="add-06" class="text" placeholder="" value="주요 거래처" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="add-07">시장점유율(%)</label>
                  <input type="text" name="" id="add-07" class="text" placeholder="" value="1.2" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="add-08">자본금 (원)</label>
                  <input type="text" name="" id="add-08" class="text" placeholder="" value="100,000,000,000" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="add-09">연 매출액 (원)</label>
                  <input type="text" name="" id="add-09" class="text" placeholder="" value="150,000,000,000" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="add-10">연 영업이익 (원)</label>
                  <input type="text" name="" id="add-10" class="text" placeholder="" value="750,000,000" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">대리인 정보 (기존 대리인과 동일한 경우)</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="rep-01">대리인명</label>
                  <input type="text" name="" id="rep-01" class="text" placeholder="" value="한선호" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="rep-02">실명번호</label>
                  <input type="text" name="" id="rep-02" class="text" placeholder="" value="782323-1029837" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">첨부파일</a></h3>
            <ul class="file-download">
              <li>
                <span class="label">법인 사업자 증명서류</span>
                <ul class="file">
                  <li><span>법인 사업자 증명서류.jpg</span><a href="#">다운로드</a></li>
                </ul>
              </li>
              <li>
                <span class="label">거래자금 원천 증빙서류</span>
                <ul class="file">
                  <li><span>통장사본.pdf</span><a href="#">다운로드</a></li>
                  <li><span>추가된 통장사본.jpg</span><a href="#">다운로드</a></li>
                </ul>
              </li>
              <li>
                <span class="label">기타 증빙서류</span>
                <ul class="file">
                  <li><span>기타 증빙서류.jpg</span><a href="#">다운로드</a></li>
                </ul>
              </li>
            </ul>
          </section>

          <div class="button-box">
            <a href="#" class="btn regular blue-line left">이전</a>
            <a href="#" class="btn regular blue">다음</a>
          </div>
        </section>
      </main>

    </div>   <!-- #wrapper -->

<script>
'use strict';

setSectionFold();

function setSectionFold() {
  const sections = document.querySelectorAll('section.fold');
  const sectionHeader = document.querySelectorAll('section.fold h3 a');

  sectionHeader.forEach(function(header) {
    header.addEventListener('click', function() {
      const that = this;
      this.closest('section').classList.toggle('open');
    }, false);
  });
}


</script>

  </body>
</html>