<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>뷰페이지(EDD/개인) | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 뷰페이지(EDD/개인) 페이지" />
  </head>
  <body class="sub viewpage-edd-private">
    <div id="wrapper">
      
      <%@ include file='../include/header.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>

        <h2><span class="before">다우데이타 220-23-10388 님이</span>제출해주신 가맹점 정보입니다.</h2>

        <section class="content">
          <section class="fold open">
            <h3><a href="#">기본정보</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="basic-01">가맹점 구분</label>
                  <input type="text" name="" id="basic-01" class="text" placeholder="" value="개인사업자" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="basic-02">거래 목적</label>
                  <input type="text" name="" id="basic-02" class="text" placeholder="" value="사업상 거래" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="basic-03">거래자금의 원천 및 출처</label>
                  <input type="text" name="" id="basic-03" class="text" placeholder="" value="근로 및 연금소득" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">주요 거래 정보</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="transaction-01">거래대상</label>
                  <input type="text" name="" id="transaction-01" class="text" placeholder="" value="의료품 납품" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="transaction-02">예상 거래 횟수 (월)</label>
                  <input type="text" name="" id="transaction-02" class="text" placeholder="" value="250회" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="transaction-03">거래금액 (월)</label>
                  <input type="text" name="" id="transaction-03" class="text" placeholder="" value="250,000,000" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">대표자 외 추가 직업 유무</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="add-01">추가 직업 유무</label>
                  <input type="text" name="" id="add-01" class="text" placeholder="" value="아니오" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="add-02">직업/업종</label>
                  <input type="text" name="" id="add-02" class="text" placeholder="" readonly="readonly" value="" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">추가 대표자 정보</a></h3>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="ceo2-01">대표자명</label>
                  <input type="text" name="" id="ceo2-01" class="text" placeholder="" value="성백진" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo2-02">실명번호</label>
                  <input type="text" name="" id="ceo2-02" class="text" placeholder="" value="782323-1029837" />
                </div>
              </li>
            </ul>
          </section>

          <section class="fold">
            <h3><a href="#">첨부파일</a></h3>
            <ul class="file-download">
              <li>
                <span class="label">대표자 재직 증명서</span>
                <ul class="file">
                  <li><span>재직증명서.jpg</span><a href="#">다운로드</a></li>
                </ul>
              </li>
              <li>
                <span class="label">거래자금 원천 증빙서류</span>
                <ul class="file">
                  <li><span>통장사본.pdf</span><a href="#">다운로드</a></li>
                  <li><span>추가된 통장사본.jpg</span><a href="#">다운로드</a></li>
                </ul>
              </li>
              <li>
                <span class="label">대표자 신분증 사본</span>
                <ul class="file">
                  <li><span>다우데이타 대표자 신분증.jpg</span><a href="#">다운로드</a></li>
                </ul>
              </li>
            </ul>
          </section>

          <div class="button-box">
            <a href="#" class="btn regular blue-line left">이전</a>
            <a href="#" class="btn regular blue">다음</a>
          </div>
        </section>
      </main>

    </div>   <!-- #wrapper -->

<script>
'use strict';

setSectionFold();

function setSectionFold() {
  const sections = document.querySelectorAll('section.fold');
  const sectionHeader = document.querySelectorAll('section.fold h3 a');

  sectionHeader.forEach(function(header) {
    header.addEventListener('click', function() {
      const that = this;
      this.closest('section').classList.toggle('open');
    }, false);
  });
}


</script>

  </body>
</html>