<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>사업자 번호 | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 사업자 번호 페이지" />
  </head>
  <body class="sub business-id">
    <div id="wrapper" class="top-padding">
      
      <%@ include file='../include/header.jsp'; %>
      <%@ include file='../include/header-stage-01.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>
        <h2>사업자등록번호를 입력해 주세요.</h2>

        <section class="content">
          <ul class="form">
            <li>
              <div class="form-box">
                <label for="business-id">사업자등록번호</label>
                <input type="text" name="" id="business-id" class="text" />
              </div>
            </li>
          </ul>

          <div class="button-box">
            <a href="#" class="btn regular blue-line left pc">이전</a>
            <a href="#" class="btn regular blue disabled">다음</a>
          </div>
        </section>
      </main>

      <div id="test-button">
        <a href="#" class="btn small blue-line" onclick="displayFormError('#business-id', '없는 사업자등록번호 입니다. 다시 확인해주세요.');">폼 오류표시</a>
        <a href="#" class="btn small blue-line" onclick="resetFormError('#business-id');">폼 초기화</a>
        <a href="#" class="btn small blue-line" onclick="enableButton();">다음버튼활성화</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'fail', title: '신청 진행불가', content: '이미 신청중인 사업자번호입니다.<br />기존 신청서 삭제 후 진행 부탁드립니다.'}, this);">팝업창1</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'fail', title: '개인사업자 대리신청 불가 안내', content: '영업대행사 대리신청은 법인 사업자만 가능합니다.<br />개인 사업자는 직접 계약서 제출 안내 부탁드립니다.'}, this);">팝업창2</a>
      </div>

    </div>   <!-- #wrapper -->

<script>
'use strict';

// 진행단계 표시
setHeaderStage(0.25);

function enableButton() {
  const btn = document.querySelector('a.btn.blue');
  btn.classList.toggle('disabled');
}




</script>

  </body>
</html>