<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>개인사업자정보 | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 개인사업자정보 페이지" />
  </head>
  <body class="sub business-info-sole">
    <div id="wrapper" class="top-padding">
      
      <%@ include file='../include/header.jsp'; %>
      <%@ include file='../include/header-stage-01.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>

        <h2><span class="before">다우데이타 220-81-01733</span>사업자 정보를 입력해 주세요.</h2>

        <section class="content">
          <ul class="form two-column">
            <li>
              <div class="form-box">
                <label for="business-type">사업자 유형</label>
                <input type="text" name="" id="business-type" class="text" readonly="readonly" value="" />
              </div>
            </li>
            <li></li>
            <li>
              <div class="form-box">
                <label for="company-name-ko">상호명 (국문)</label>
                <input type="text" name="" id="company-name-ko" class="text" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="company-name-en">상호명 (영문)</label>
                <input type="text" name="" id="company-name-en" class="text" value="" />
              </div>
            </li>
            <li>
              <div class="form-box guide">
                <label for="ceo-type">대표자 형태</label>
                <select name="" id="ceo-type">
                  <option value="">-- 선택 --</option>
                  <option value="">단독대표 1명</option>
                  <option value="">공동대표</option>
                  <option value="">각자대표</option>
                </select>
                <span class="guide">공동대표자 4인 이상인 경우, 키움페이 고객센터로 문의 바랍니다.</span>
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="num-ceo">대표자 수</label>
                <input type="text" name="" id="num-ceo" class="text" readonly="readonly" />
              </div>
              <div class="form-box">
                <label for="num-ceo-2">대표자 수</label>
                <select name="" id="num-ceo-2">
                  <option value="">2명</option>
                  <option value="">3명</option>
                </select>
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="service-name">서비스(사이트) 명</label>
                <input type="text" name="" id="service-name" class="text" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="site-url">사이트 주소(URL)</label>
                <input type="text" name="" id="site-url" class="text" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="com-phone">회사 전화번호</label>
                <input type="text" name="" id="com-phone" class="text" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="com-email">회사 이메일</label>
                <input type="text" name="" id="com-email" class="text" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="tax-type">과세구분</label>
                <select name="" id="tax-type">
                  <option value="">-- 선택 --</option>
                  <option value="">과세구분 1</option>
                  <option value="">과세구분 2</option>
                  <option value="">과세구분 3</option>
                  <option value="">과세구분 4</option>
                </select>
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="credit-type">신탁구분
                  <span class="help">
                    <a href="#"><span>입력도움말</span></a>
                    <span class="popup"><em>※ 신탁이란?</em>위탁자와 수탁자 간 계약 하에 위탁자의 재산을 수탁자에게 이전한 후, 수익자 또는 특정 목적을 위하여 관리, 운용하도록 하는 행위</span>
                  </span>
                </label>
                <select name="" id="credit-type">
                  <option value="">-- 선택 --</option>
                  <option value="">신탁구분 1</option>
                  <option value="">신탁구분 2</option>
                  <option value="">신탁구분 3</option>
                  <option value="">신탁구분 4</option>
                </select>
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="coin-type">가상자산사업자 여부
                  <span class="help">
                    <a href="#"><span>입력도움말</span></a>
                    <span class="popup"><em>※ 가상자산사업이란?</em>전자적으로 거래되는 전자적 증표를 매매, 교환, 이전, 보관, 관리하는 사업</span>
                  </span>
                </label>
                <select name="" id="coin-type">
                  <option value="">-- 선택 --</option>
                  <option value="">Y</option>
                  <option value="">N</option>
                </select>
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="found-date">사업자등록증 상 개업연월일</label>
                <input type="text" name="" id="found-date" class="text date" date-format="date" />
              </div>
            </li>
            <li class="full address">
              <div class="form-box">
                <label for="address-country">사업장 소재지</label>
                <select name="" id="address-country">
                  <option value="">-- 선택 --</option>
                  <option value="">대한민국</option>
                  <option value="">대한민국</option>
                  <option value="">대한민국</option>
                </select>
              </div>
              <div class="form-box button">
                <input type="text" name="" id="address-post" class="text" title="우편번호" />
                <a href="#" class="btn regular gray">우편번호</a>
              </div>
              <div class="form-box">
                <input type="text" name="" id="address-common" class="text" title="공통주소" placeholder="기본주소" />
              </div>
              <div class="form-box">
                <input type="text" name="" id="address-detail" class="text" title="상세주소" placeholder="상세주소" />
              </div>
              <div class="form-box">
                <p class="checkbox"><input type="checkbox" name="" id="main-address" value="" /><label for="main-address">본점의 주소가 위와 다른가요?</label></p>
              </div>
            </li>
            <li class="full address main">
              <div class="form-box">
                <label for="main-address-country">본점 소재지</label>
                <select name="" id="main-address-country">
                  <option value="">-- 선택 --</option>
                  <option value="">대한민국</option>
                  <option value="">대한민국</option>
                  <option value="">대한민국</option>
                </select>
              </div>
              <div class="form-box button">
                <input type="text" name="" id="main-address-post" class="text" title="우편번호" />
                <a href="#" class="btn regular gray">우편번호</a>
              </div>
              <div class="form-box">
                <input type="text" name="" id="main-address-common" class="text" title="공통주소" placeholder="기본주소" />
              </div>
              <div class="form-box">
                <input type="text" name="" id="main-address-detail" class="text" title="상세주소" placeholder="상세주소" />
              </div>
            </li>
            <li>
              <div class="form-box button">
                <label for="industry-code">표준산업분류코드</label>
                <input type="text" name="" id="industry-code" class="text" />
                <a href="#" class="btn regular gray">찾기</a>
              </div>
            </li>
            <li></li>
            <li>
              <div class="form-box guide">
                <label for="business-field">업종</label>
                <input type="text" name="" id="business-field" class="text" />
                <span class="guide">업종이 2개 이상인 경우 주요한 결제 업종을 입력해주세요.</span>
              </div>
            </li>
            <li>
              <div class="form-box guide">
                <label for="business-pattern">업태</label>
                <input type="text" name="" id="business-pattern" class="text" />
                <span class="guide">업태가 2개 이상인 경우 주요한 결제 업태를 입력해주세요.</span>
              </div>
            </li>

          </ul>

          <div class="button-box">
            <a href="#" class="btn regular blue-line left pc">이전</a>
            <a href="#" class="btn regular blue disabled">다음</a>
          </div>
        </section>
      </main>

      <div id="test-button">
        <a href="#" class="btn small blue-line" onclick="enableButton();">다음버튼활성화</a>
        <a href="#" class="btn small blue-line" onclick="showLayerPopup('#layer-category', this);">팝업창1</a>
      </div>

    </div>   <!-- #wrapper -->

    <div id="layer-category">
      <h3>표준산업 분류코드 조회</h3>
      <a href="#" class="close mobile"><img alt="" src="/img/icon-header-close.png" /></a>
      <div class="container">
        <ul class="tab">
          <li class="on"><a href="#">분류로 찾기</a></li>
          <li><a href="#">키워드로 찾기</a></li>
        </ul>
        <div class="search-box on">
          <ul class="form two-column">
            <li>
              <div class="form-box">
                <select name="" id="field-level-1">
                  <option value="">-- 대분류 --</option>
                  <option value="">대분류 1</option>
                  <option value="">대분류 1</option>
                  <option value="">대분류 1</option>
                  <option value="">대분류 1</option>
                  <option value="">대분류 1</option>
                </select>
              </div>
            </li>
            <li>
              <div class="form-box">
                <select name="" id="field-level-2">
                  <option value="">-- 중분류 --</option>
                  <option value="">대분류 1</option>
                  <option value="">대분류 1</option>
                  <option value="">대분류 1</option>
                  <option value="">대분류 1</option>
                  <option value="">대분류 1</option>
                </select>
              </div>
            </li>
            <li class="full">
              <div class="form-box">
                <select name="" id="field-level-3">
                  <option value="">-- 소분류 --</option>
                  <option value="">대분류 1</option>
                  <option value="">대분류 1</option>
                  <option value="">대분류 1</option>
                  <option value="">대분류 1</option>
                  <option value="">대분류 1</option>
                </select>
              </div>
            </li>
          </ul>
          <div class="button-box center">
            <a href="#" class="btn small blue-line">초기화</a>
            <a href="#" class="btn small blue">전체조회</a>
          </div>
        </div>
        <div class="search-box">
          <ul class="form two-column">
            <li>
              <div class="form-box">
                <label for="industry-code-search">표준산업분류코드</label>
                <input type="text" name="" id="industry-code-search" class="text" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="field-name-search">분류명</label>
                <input type="text" name="" id="field-name-search" class="text" />
              </div>
            </li>
          </ul>
          <div class="button-box center">
            <a href="#" class="btn small blue-line mobile">초기화</a>
            <a href="#" class="btn small blue">검색</a>
          </div>
        </div>
        <div class="code-list">
          <ul class="category-list">
            <li>
              <input type="radio" name="category" id="category-001" value="" />
              <label for="category-001">
                <em class="code">01152</em>
                <p><em><span>농업, 임업 및 어업 (대분류)</span><span>시설작물 재배업 (중분류)</span></em><span>채소, 화훼 및 과실작물 시설 재배업 (세세분류)</span></p>
              </label>
            </li>
            <li>
              <input type="radio" name="category" id="category-002" value="" />
              <label for="category-002">
                <em class="code">01152</em>
                <p><em><span>농업, 임업 및 어업 (대분류)</span><span>시설작물 재배업 (중분류)</span></em><span>채소, 화훼 및 과실작물 시설 재배업 (세세분류)</span></p>
              </label>
            </li>
            <li>
              <input type="radio" name="category" id="category-003" value="" />
              <label for="category-003">
                <em class="code">01152</em>
                <p><em><span>농업, 임업 및 어업 (대분류)</span><span>시설작물 재배업 (중분류)</span></em><span>채소, 화훼 및 과실작물 시설 재배업 (세세분류)</span></p>
              </label>
            </li>
            <li>
              <input type="radio" name="category" id="category-004" value="" />
              <label for="category-004">
                <em class="code">01152</em>
                <p><em><span>농업, 임업 및 어업 (대분류)</span><span>시설작물 재배업 (중분류)</span></em><span>채소, 화훼 및 과실작물 시설 재배업 (세세분류)</span></p>
              </label>
            </li>
            <li>
              <input type="radio" name="category" id="category-005" value="" />
              <label for="category-005">
                <em class="code">01152</em>
                <p><em><span>농업, 임업 및 어업 (대분류)</span><span>시설작물 재배업 (중분류)</span></em><span>채소, 화훼 및 과실작물 시설 재배업 (세세분류)</span></p>
              </label>
            </li>
            <li>
              <input type="radio" name="category" id="category-006" value="" />
              <label for="category-006">
                <em class="code">01152</em>
                <p><em><span>농업, 임업 및 어업 (대분류)</span><span>시설작물 재배업 (중분류)</span></em><span>채소, 화훼 및 과실작물 시설 재배업 (세세분류)</span></p>
              </label>
            </li>
            <li>
              <input type="radio" name="category" id="category-007" value="" />
              <label for="category-007">
                <em class="code">01152</em>
                <p><em><span>농업, 임업 및 어업 (대분류)</span><span>시설작물 재배업 (중분류)</span></em><span>채소, 화훼 및 과실작물 시설 재배업 (세세분류)</span></p>
              </label>
            </li>
          </ul>
        </div>
      </div>
      <div class="button-box center pc">
        <a href="#" class="btn small blue-line close">닫기</a>
      </div>
    </div>

<script>
'use strict';

// 진행단계 표시
setHeaderStage(1.5);


// 산업분류코드 UI
setIndustryCodeUI();
function setIndustryCodeUI() {
  const tabs = document.querySelectorAll('#layer-category ul.tab > li > a');
  const searchBoxs = document.querySelectorAll('#layer-category div.search-box');

  tabs.forEach(function(tab, i) {
    tab.addEventListener('click', function() {
      tabs.forEach(function(tab) {
        tab.parentElement.classList.remove('on');
      });
      tabs[i].parentElement.classList.add('on');
      searchBoxs.forEach(function(searchBox) {
        searchBox.classList.remove('on');
      });
      searchBoxs[i].classList.add('on');
    });
  });
}

// 대표자 선택 UI
setCeoSelect();
document.querySelector('#ceo-type').addEventListener('change', function() {
  setCeoSelect();
}, false);

function setCeoSelect() {
  const select = document.querySelector('#ceo-type');
  const target1 = document.querySelector('#num-ceo');
  const target2 = document.querySelector('#num-ceo-2');
  let numSelected = 0;
  select.querySelectorAll('option').forEach(function(option, i) {
    if (option.selected === true) {
      if (i === 0) {
        target1.parentElement.style.display = 'block';
        target2.parentElement.style.display = 'none';
        target1.value = '';
      } else if (i === 1) {
        target1.parentElement.style.display = 'block';
        target2.parentElement.style.display = 'none';
        target1.value = '1명';
      } else {   // 공동/각자대표인 경우
        target1.parentElement.style.display = 'none';
        target2.parentElement.style.display = 'block';
      }
    }
  });
}

// 본점 소재지 선택 UI
setMainAddress();
document.querySelector('#main-address').addEventListener('change', function() {
  setMainAddress();
}, false);

function setMainAddress() {
  const check = document.querySelector('#main-address');
  const target = document.querySelector('li.address.main');

  if (check.checked === true) {
    target.style.display = 'block';
  } else {
    target.style.display = 'none';
  }
}



function enableButton() {
  const btn = document.querySelector('a.btn.blue');
  btn.classList.toggle('disabled');
}




</script>

  </body>
</html>