<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>정산계좌 | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 정산계좌 페이지" />
  </head>
  <body class="sub calculate-account">
    <div id="wrapper" class="top-padding">
      
      <%@ include file='../include/header.jsp'; %>
      <%@ include file='../include/header-stage-01.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>
        
        <h2><span class="before">다우데이타 220-81-01733</span>정산계좌 정보를 입력해 주세요.</h2>

        <section class="content">
          <ul class="form two-column">
            <li>
              <div class="form-box">
                <label for="bank">은행명</label>
                <select name="" id="bank">
                  <option value="">-- 선택 --</option>
                  <option value="">국민은행</option>
                  <option value="">국민은행</option>
                  <option value="">국민은행</option>
                  <option value="">국민은행</option>
                </select>
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="account">계좌번호
                  <span class="help">
                    <a href="#"><span>입력도움말</span></a>
                    <span class="popup">※ 개인사업자는 대표자 혹은 상호명과 일치, 법인사업자는 상호명과 일치해야 합니다.</span>
                  </span>
                </label>
                <input type="text" name="" id="account" class="text" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="holder">예금주</label>
                <input type="text" name="" id="holder" class="text" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="tax-email">세금계산서 수신 이메일</label>
                <input type="text" name="" id="tax-email" class="text" value="" />
              </div>
            </li>
          </ul>

          <div class="button-box">
            <a href="#" class="btn regular blue-line left pc">이전</a>
            <a href="#" class="btn regular blue disabled">다음</a>
          </div>
        </section>
      </main>

      <div id="test-button">
        <a href="#" class="btn small blue-line" onclick="enableButton();">다음버튼활성화</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'confirm', title: '정산 계좌 확인 팝업', content: '예금주 : ㈜ 다우데이타<br />키움저축은행 10002015132846로<br />정산계좌를 설정하시겠습니까?', buttons: ['닫기', '제출하기']}, this);">팝업창1</a>
      </div>

    </div>   <!-- #wrapper -->

<script>
'use strict';

// 진행단계 표시
setHeaderStage(4);


function enableButton() {
  const btn = document.querySelector('a.btn.blue');
  btn.classList.toggle('disabled');
}






</script>

  </body>
</html>