<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>대표자정보 | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 대표자정보 페이지" />
  </head>
  <body class="sub ceo-info">
    <div id="wrapper" class="top-padding">
      
      <%@ include file='../include/header.jsp'; %>
      <%@ include file='../include/header-stage-01.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>

        <h2><span class="before">다우데이타 220-81-01733</span>대표자 정보를 입력해 주세요.</h2>

        <section class="content">
          <h3 class="title">사업자등록증 상 기재된 대표자 정보를 모두 입력해주세요. (공동대표자 정보 입력 필수)</h3>

          <section class="repeat">
            <h4 class="name">대표자 1</h4>
            <ul class="form two-column">
              <li>
                <div class="form-box">
                  <label for="ceo-name-1">대표자명</label>
                  <input type="text" name="" id="ceo-name-1" class="text" value="" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="ceo-name-en-1">대표자 영문명</label>
                  <input type="text" name="" id="ceo-name-en-1" class="text" value="" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="birth-date-1">생년월일</label>
                  <input type="text" name="" id="birth-date-1" class="text date" placeholder="YYYY-MM-DD" value="" date-format="date" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="sex-type-1">성별</label>
                  <select name="" id="sex-type-1">
                    <option value="">-- 선택 --</option>
                    <option value="">남성</option>
                    <option value="">여성</option>
                  </select>
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="mobile-1">휴대폰번호</label>
                  <input type="text" name="" id="mobile-1" class="text" value="" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="email-1">이메일</label>
                  <input type="text" name="" id="email-1" class="text" value="" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="nationality-1">국적</label>
                  <select name="" id="nationality-1" class="nationality">
                    <option value="">-- 선택 --</option>
                    <option value="">대한민국</option>
                    <option value="">미국</option>
                  </select>
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="residence-country-1">거주국가</label>
                  <select name="" id="residence-country-1" class="residence">
                    <option value="">-- 선택 --</option>
                    <option value="">대한민국</option>
                    <option value="">미국</option>
                    <option value="">영국</option>
                  </select>
                </div>
              </li>
              <li class="full address">
                <div class="form-box button">
                  <label for="address-post-1">주소</label>
                  <input type="text" name="" id="address-post-1" class="text" title="우편번호" />
                  <a href="#" class="btn regular gray">우편번호</a>
                </div>
                <div class="form-box">
                  <input type="text" name="" id="address-common-1" class="text" title="기본주소" placeholder="기본주소" />
                </div>
                <div class="form-box">
                  <input type="text" name="" id="address-detail-1" class="text" title="상세주소" placeholder="상세주소" />
                </div>
              </li>
            </ul>
          </section>

          <!-- <p class="add-section"><a href="#">대표자정보 추가</a></p> -->

          <div class="button-box">
            <a href="#" class="btn regular blue-line left pc">이전</a>
            <a href="#" class="btn regular blue disabled">다음</a>
          </div>
        </section>
      </main>

      <div id="test-button">
        <a href="#" class="btn small blue-line" onclick="enableButton();">다음버튼활성화</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'fail', title: '대표자 정보 부족', content: '사업자정보 입력 페이지에 적어주신<br />대표자 명 수 만큼 작성해주세요.'}, this);">팝업창1</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'confirm', title: '공동 대표자 삭제 확인', content: '대표자 정보 [2] 정보를 삭제할까요?', buttons: ['취소', '삭제']}, this);">팝업창2</a>
      </div>

    </div>   <!-- #wrapper -->

<script>
'use strict';

// 진행단계 표시
setHeaderStage(2.33);


// 대표자 정보 추가
setAddInfo('대표자 2');
setAddInfo('대표자 3');


function setAddInfo(name) {
  const firstInfo = document.querySelector('section.repeat:nth-of-type(1)');
  const lastInfo = document.querySelector('div.button-box');

  let copyedHTML = firstInfo.cloneNode(true);
  copyedHTML.querySelector('h4.name').innerText = name;
  lastInfo.before(copyedHTML);
  resetInfoList();

  function resetInfoList() {
    const infoList = document.querySelectorAll('section.repeat');
    infoList.forEach(function(info, i) {
      let index = i + 1;
      // 첫번째 리스트는 제외
      if (i > 0) {
        info.querySelectorAll('[for]').forEach(function(form) {
          let oldText = form.getAttribute('for');
          let newText = oldText.replace(/-\d+$/, '-' + index);
          form.setAttribute('for', newText);
        });
        info.querySelectorAll('[id]').forEach(function(form) {
          let oldText = form.getAttribute('id');
          let newText = oldText.replace(/-\d+$/, '-' + index);
          form.setAttribute('id', newText);
        });
      }
    });
  }
}


// 국적선택
setNationality();
function setNationality() {
  document.addEventListener('change', function(e) {
    let currentNode = e.target;
    let lastNode = e.currentTarget;
    while (currentNode !== lastNode) {
      if (currentNode.matches('select.nationality') === true) {
        // console.log('nationality');
        let value = '';
        currentNode.querySelectorAll('option').forEach(function(option) {
          if (option.selected === true) value = option.innerText;
        });
        if (value === '대한민국') {
          const target = currentNode.closest('section').querySelector('select.residence');
          target.querySelectorAll('option').forEach(function(option) {
            if (option.innerText === '대한민국') {
              option.selected = true;
              target.classList.remove('not-selected');
            }
          });
        }
        return false;
      }
      currentNode = currentNode.parentNode;
    }
  }, false);
}





function enableButton() {
  const btn = document.querySelector('a.btn.blue');
  btn.classList.toggle('disabled');
}




</script>

  </body>
</html>