<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>상호명 | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 상호명 페이지" />
  </head>
  <body class="sub company-name">
    <div id="wrapper" class="top-padding">
      
      <%@ include file='../include/header.jsp'; %>
      <%@ include file='../include/header-stage-01.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>

        <h2><span class="before">다우데이타 220-81-01733</span>사업자등록증 상 상호명을 입력해주세요.</h2>

        <section class="content">
          <ul class="form">
            <li>
              <div class="form-box guide">
                <label for="company-name">상호명</label>
                <input type="text" name="" id="company-name" class="text" />
                <span class="guide">띄어쓰기, 맞춤법에 유의해주세요!</span>
              </div>
            </li>
          </ul>

          <div class="button-box">
            <a href="#" class="btn regular blue-line left pc">이전</a>
            <a href="#" class="btn regular blue disabled">다음</a>
          </div>
        </section>
      </main>

      <div id="test-button">
        <a href="#" class="btn small blue-line" onclick="displayFormError('#company-name', '오류 메세지. 다시 확인해주세요.');">폼 오류표시</a>
        <a href="#" class="btn small blue-line" onclick="resetFormError('#company-name');">폼 초기화</a>
        <a href="#" class="btn small blue-line" onclick="enableButton();">다음버튼활성화</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'confirm', title: '상호명 확인', content: '사업자등록증 상 상호명을 정확히<br />입력해야 원활한 진행이 가능합니다.', buttons: ['확인']}, this);">팝업창1</a>
      </div>

    </div>   <!-- #wrapper -->

<script>
'use strict';

// 진행단계 표시
setHeaderStage(0.75);

function enableButton() {
  const btn = document.querySelector('a.btn.blue');
  btn.classList.toggle('disabled');
}




</script>

  </body>
</html>