<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>대리인정보 | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 대리인정보 페이지" />
  </head>
  <body class="sub deputy-info">
    <div id="wrapper" class="top-padding">
      
      <%@ include file='../include/header.jsp'; %>
      <%@ include file='../include/header-stage-01.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>

        <h2><span class="before">다우데이타 220-81-01733</span>대리인 정보를 입력해 주세요.</h2>

        <section class="content">
          <ul class="form two-column">
            <li>
              <div class="form-box">
                <label for="deputy-name">대리인명</label>
                <input type="text" name="" id="deputy-name" class="text" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="deputy-name-en">대리인 영문명</label>
                <input type="text" name="" id="deputy-name-en" class="text" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="birth-date">생년월일</label>
                <input type="text" name="" id="birth-date" class="text date" placeholder="YYYY-MM-DD" value="" date-format="date" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="sex-type">성별</label>
                <select name="" id="sex-type">
                  <option value="">-- 선택 --</option>
                  <option value="">남성</option>
                  <option value="">여성</option>
                </select>
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="mobile">휴대폰번호</label>
                <input type="text" name="" id="mobile" class="text" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="email">이메일</label>
                <input type="text" name="" id="email" class="text" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="nationality">국적</label>
                <select name="" id="nationality">
                  <option value="">-- 선택 --</option>
                  <option value="">대한민국</option>
                </select>
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="residence-country">거주국가</label>
                <input type="text" name="" id="residence-country" class="text" readonly="readonly" value="대한민국" />
              </div>
            </li>
            <li class="full address">
              <div class="form-box button">
                <label for="address-post">주소</label>
                <input type="text" name="" id="address-post" class="text" title="우편번호" />
                <a href="#" class="btn regular gray">우편번호</a>
              </div>
              <div class="form-box">
                <input type="text" name="" id="address-common" class="text" title="공통주소" placeholder="기본주소" />
              </div>
              <div class="form-box">
                <input type="text" name="" id="address-detail" class="text" title="상세주소" placeholder="상세주소" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="relateion">신청인과의 관계</label>
                <select name="" id="relateion">
                  <option value="">-- 선택 --</option>
                  <option value="">신청인과의 관계 1</option>
                  <option value="">신청인과의 관계 2</option>
                  <option value="" data-selector=".relation-etc">기타</option>
                </select>
              </div>
            </li>
            <li>
              <div class="form-box relation-etc">
                <label for="relation-etc"></label>
                <input type="text" name="" id="relation-etc" class="text" value="" />
              </div>
            </li>
          </ul>

          <div class="button-box">
            <a href="#" class="btn regular blue-line left pc">이전</a>
            <a href="#" class="btn regular blue disabled">다음</a>
          </div>
        </section>
      </main>

      <div id="test-button">
        <a href="#" class="btn small blue-line" onclick="enableButton();">다음버튼활성화</a>
      </div>

    </div>   <!-- #wrapper -->

<script>
'use strict';

// 진행단계 표시
setHeaderStage(2.9);


// 기타요소 표시
setVisibilityCheck();


function enableButton() {
  const btn = document.querySelector('a.btn.blue');
  btn.classList.toggle('disabled');
}




</script>

  </body>
</html>