<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>EDD(법인) | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 EDD(법인) 페이지" />
  </head>
  <body class="sub edd-corp">
    <div id="wrapper" class="top-padding">
      
      <%@ include file='../include/header.jsp'; %>
      <%@ include file='../include/header-stage-02.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>

        <h2><span class="before">다우데이타 220-81-01733</span>추가고객확인 정보를 입력해 주세요.</h2>

        <section class="content">
          <ul class="form two-column">
            <li>
              <div class="form-box">
                <label for="deal-purpose">거래목적을 선택해주세요</label>
                <select name="" id="deal-purpose">
                  <option value="">-- 선택 --</option>
                  <option value="">거래목적 1</option>
                  <option value="">거래목적 2</option>
                  <option value="" data-selector=".deal-purpose">기타</option>
                </select>
              </div>
            </li>
            <li>
              <div class="form-box deal-purpose">
                <label for="deal-purpose-etc"></label>
                <input type="text" name="" id="deal-purpose-etc" class="text" placeholder="거래 목적을 입력해주세요" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="fund-source">거래자금의 원천 및 출처</label>
                <select name="" id="fund-source">
                  <option value="">-- 선택 --</option>
                  <option value="">거래자금의 원천 및 출처 1</option>
                  <option value="">거래자금의 원천 및 출처 2</option>
                  <option value="" data-selector=".fund-source">기타</option>
                </select>
              </div>
            </li>
            <li>
              <div class="form-box fund-source">
                <label for="fund-source-etc"></label>
                <input type="text" name="" id="fund-source-etc" class="text" placeholder="거래 자금의 원천을 입력해주세요" value="" />
              </div>
            </li>
          </ul>

          <h3 class="title">주요 거래 대상 및 횟수, 거래 금액을 알려주세요.<span>(새로 사업을 시작하신다면, 예상 거래 대상에 대해 적어주세요.)</span></h3>
          <ul class="form two-column">
            <li>
              <div class="form-box">
                <label for="deal-partner">거래 대상</label>
                <input type="text" name="" id="deal-partner" class="text" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="deal-count">예상 거래 횟수 (월)</label>
                <input type="text" name="" id="deal-count" class="text" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="deal-amount">거래금액 (원)</label>
                <input type="text" name="" id="deal-amount" class="text" value="" />
              </div>
            </li>
          </ul>

          <ul class="form two-column">
            <li>
              <div class="form-box">
                <label for="corp-type">법인유형</label>
                <select name="" id="corp-type">
                  <option value="">-- 선택 --</option>
                  <option value="">법인유형 1</option>
                  <option value="">법인유형 2</option>
                </select>
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="is-ipo">상장여부</label>
                <select name="" id="is-ipo">
                  <option value="">-- 선택 --</option>
                  <option value="">상장여부 1</option>
                  <option value="">상장여부 2</option>
                </select>
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="stock-place">상장하신 거래소</label>
                <select name="" id="stock-place">
                  <option value="">-- 선택 --</option>
                  <option value="">거래소 1</option>
                  <option value="">거래소 2</option>
                </select>
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="stock-place-etc"></label>
                <input type="text" name="" id="stock-place-etc" class="text" placeholder="상장 거래소를 적어주세요" value="" />
              </div>
            </li>
          </ul>

          <h3 class="title">회사의 재정상황 등 추가적인 정보를 입력해주세요.</span></h3>
          <ul class="form two-column">
            <li>
              <div class="form-box">
                <label for="service">주요 상품/서비스</label>
                <input type="text" name="" id="service" class="text" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="market-share">시장점유율 (%)</label>
                <input type="text" name="" id="market-share" class="text" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="num-employee">직원수 (명)</label>
                <input type="text" name="" id="num-employee" class="text" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="customers">주요 거래처</label>
                <input type="text" name="" id="customers" class="text" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="corp-fund">자본금 (원)</label>
                <input type="text" name="" id="corp-fund" class="text" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="annual-sales">연 매출액 (원)</label>
                <input type="text" name="" id="annual-sales" class="text" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="annual-revenue">연 영업이익 (원)</label>
                <input type="text" name="" id="annual-revenue" class="text" value="" />
              </div>
            </li>
          </ul>

          
          <div class="button-box">
            <a href="#" class="btn regular blue-line left pc">이전</a>
            <a href="#" class="btn regular blue disabled">다음</a>
          </div>
        </section>
      </main>

      <div id="test-button">
        <a href="#" class="btn small blue-line" onclick="enableButton();">다음버튼활성화</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'fail', title: '대리인 신청 불가', content: '<em class=\'red\'>가맹점 정보로 제출한 대표자만 제출 가능합니다.<br />(신청자를 대표자로 선택해주세요.)</em><br />추가 문의는 02-3410-0000 으로 부탁드립니다.'}, this);">팝업창1</a>
      </div>

    </div>   <!-- #wrapper -->

<script>
'use strict';


// 진행단계 표시
setHeaderStage(1);


// 표시 유무 결정
setVisibilityCheck();


function enableButton() {
  const btn = document.querySelector('a.btn.blue');
  btn.classList.toggle('disabled');
}




</script>

  </body>
</html>