<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>첨부파일(법인) | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 첨부파일(법인) 페이지" />
  </head>
  <body class="sub file-upload-corp">
    <div id="wrapper" class="top-padding">
      
      <%@ include file='../include/header.jsp'; %>
      <%@ include file='../include/header-stage-01.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>

        <h2><span class="before">다우데이타 220-81-01733</span>첨부파일을 업로드해주세요.</h2>

        <section class="content">
          <ul class="file-upload">
            <li>
              <div class="file">
                <span class="label required">사업자 등록증 사본
                  <span class="help">
                    <a href="#"><span>입력도움말</span></a>
                    <span class="popup">
                      <em>※ 사업자등록증 사본 안내</em>
                      <span>비영리법인-단체: 고유번호증, 납세번호증 첨부 가능, 제출일자 기준 2년 이내 발급 서류만 가능</span><span>사업자등록증명원 제출 시, 3개월 이내 발급 서류 제출</span>
                    </span>
                  </span>
                </span>
                <ul class="file">
                  <li>
                    <span>(주) 다우데이타 사업자 등록증.jpg</span>
                    <a href="#" class="btn small red-line del">삭제</a>
                  </li>
                </ul>
              </div>
              <p><a href="#" class="btn small blue add" title="첨부">추가</a></p>
            </li>
            <li>
              <div class="file">
                <span class="label required">통장 사본
                  <span class="help">
                    <a href="#"><span>입력도움말</span></a>
                    <span class="popup">
                      <em>※ 통장 사본</em>
                      <span>법인 명의 통장만 가능</span>
                    </span>
                  </span>
                </span>
                <ul class="file">
                  <li>
                    <span>(주) 다우데이타 통장사본.pdf</span>
                    <a href="#" class="btn small red-line del">삭제</a>
                  </li>
                  <li>
                    <span>추가된 통장사본.jpg</span>
                    <a href="#" class="btn small red-line del">삭제</a>
                  </li>
                </ul>
              </div>
              <p><a href="#" class="btn small blue add" title="첨부">추가</a></p>
            </li>
            <li>
              <div class="file">
                <span class="label required">대표자 신분증 사본
                  <span class="help">
                    <a href="#"><span>입력도움말</span></a>
                    <span class="popup">
                      <em>※ 대표자 신분증 사본 안내 (앞/뒷면 모두 제출)</em>
                      <span>운전면허증 및 외국인등록증은 유효기간 이내 신분증 사본 제출</span>
                      <span>대한민국 국적자 : 주민등록번호 뒷자리 중 두번째 숫자부터 삭제한 주민등록증<br />(또는 이와 동일한 운전면허증)</span>
                      <span>외국인 : 외국인등록번호 뒷자리 중 두번째 숫자부터 삭제한 외국인등록증</span>
                    </span>
                  </span>
                </span>
                <ul class="file">
                  <li>
                    <span>대표자 신분증 사본.jpg</span>
                    <a href="#" class="btn small red-line del">삭제</a>
                  </li>
                </ul>
              </div>
              <p><a href="#" class="btn small blue add" title="첨부">추가</a></p>
            </li>
            <li>
              <div class="file">
                <span class="label required">법인 인감증명서
                  <span class="help">
                    <a href="#"><span>입력도움말</span></a>
                    <span class="popup">
                      <em>※ 법인 인감증명서 안내</em>
                      <span>제출일자 기준 3개월 이내 서류만 가능</span>
                      <span>비영리법인-단체 : 고유번호증, 납세번호증이 없는 단체의 경우<br />대표자 인감증명서도 제출 가능</span>
                    </span>
                  </span>
                </span>
                <ul class="file">
                  <li>
                    <span>법인 인감증명서.jpg</span>
                    <a href="#" class="btn small red-line del">삭제</a>
                  </li>
                </ul>
              </div>
              <p><a href="#" class="btn small blue add" title="첨부">추가</a></p>
            </li>
            <li>
              <div class="file">
                <span class="label required">법인 등기부등본
                  <span class="help">
                    <a href="#"><span>입력도움말</span></a>
                    <span class="popup">
                      <em>※ 법인 등기부등본 안내</em>
                      <span>- 제출일자 기준 3개월 이내 서류만 가능<br />- 말소사항 포함 제출용으로 발급하여 제출<br />- 비영리법인-단체: 납세번호증, 시설허가증 비영리단체등록증 등도 첨부 가능</span>
                    </span>
                  </span>
                </span>
                <ul class="file">
                  <li>
                    <span>법인 등기부등본.jpg</span>
                    <a href="#" class="btn small red-line del">삭제</a>
                  </li>
                </ul>
              </div>
              <p><a href="#" class="btn small blue add" title="첨부">추가</a></p>
            </li>
            <li>
              <div class="file">
                <span class="label required">주주명부/주주명부확인서
                  <span class="help">
                    <a href="#"><span>입력도움말</span></a>
                    <span class="popup">
                      <em>※ 주주명부/주주명부확인서 안내</em>
                      <span>제출일자 기준 3개월 이내 서류만 가능</span>
                      <span>비영리법인-단체 : 출자자명부, 이사회 명부, 사원 명부, 회칙, 의사록, 실소유자 관련 공문 등도 첨부 가능</span>
                    </span>
                  </span>
                </span>
                <ul class="file">
                  <li>
                    <span>주주명부/주주명부확인서.jpg</span>
                    <a href="#" class="btn small red-line del">삭제</a>
                  </li>
                </ul>
              </div>
              <p><a href="#" class="btn small blue add" title="첨부">추가</a></p>
            </li>
            <li>
              <div class="file">
                <span class="label">대리인 위임장
                  <span class="desc">(※ 대리인 신청시 필수 제출)</span>
                </span>
                <ul class="file">
                  <li>
                    <span>대리인 위임장.jpg</span>
                    <a href="#" class="btn small red-line del">삭제</a>
                  </li>
                </ul>
              </div>
              <a href="#" class="down">양식 다운</a>
              <p><a href="#" class="btn small blue add" title="첨부">추가</a></p>
            </li>
            <li>
              <div class="file">
                <span class="label">대리인 신분증 사본
                  <span class="desc">(※ 대리인 신청시 필수 제출)</span>
                  <span class="help">
                    <a href="#"><span>입력도움말</span></a>
                    <span class="popup">
                      <em>※ 대리인 신분증 사본 안내(앞/뒷면 모두 제출)</em>
                      <span>운전면허증 및 외국인등록증은 유효기간 이내 신분증 사본 제출</span>
                      <span>대한민국 국적자 : 주민번호 뒷자리 중 두번째 숫자부터 삭제한 주민등록증 (혹은 이와 동일한 운전면허증)</span>
                      <span>외국인 : 외국인등록번호 뒷자리 중 두번째 숫자부터 삭제한 외국인등록증<br />* 대리인 신분증에 기재된 주소지와 주민등록 상 주소가 다를 경우에는 주민등록번호 뒷자리 중 두번째 숫자부터 삭제한 주민등록등(초)본을 추가 제출해 주세요</span>
                    </span>
                  </span>
                </span>
                <ul class="file">
                  <li>
                    <span>대리인 신분증 사본.jpg</span>
                    <a href="#" class="btn small red-line del">삭제</a>
                  </li>
                </ul>
              </div>
              <p><a href="#" class="btn small blue add" title="첨부">추가</a></p>
            </li>
            <li>
              <div class="file">
                <span class="label">실제소유자 증명서류</span>
                <ul class="file">
                  <li>
                    <span>실제소유자 증명서류.jpg</span>
                    <a href="#" class="btn small red-line del">삭제</a>
                  </li>
                </ul>
              </div>
              <a href="#" class="down">양식 다운</a>
              <p><a href="#" class="btn small blue add" title="첨부">추가</a></p>
            </li>
            <li>
              <div class="file">
                <span class="label">설립목적 검증 서류
                  <span class="desc">(※ 비영리법인단체 필수 제출)</span>
                  <span class="help">
                    <a href="#"><span>입력도움말</span></a>
                    <span class="popup">
                      <em>※ 설립목적 검증 서류 안내</em>
                      <span>- 정관<br />- 이사회 회의록<br />- 사원총회 의사록 등</span>
                    </span>
                  </span>
                </span>
                <ul class="file">
                  <li>
                    <span>설립목적 검증 서류.jpg</span>
                    <a href="#" class="btn small red-line del">삭제</a>
                  </li>
                </ul>
              </div>
              <p><a href="#" class="btn small blue add" title="첨부">추가</a></p>
            </li>
          </ul>

          <div class="button-box">
            <a href="#" class="btn regular blue-line left pc">이전</a>
            <a href="#" class="btn regular blue disabled">다음</a>
          </div>
        </section>
      </main>

      <div class="layer-help mobile">
        <div class="content">
          <!--
          <em>※ 실제소유자 신분증 사본 안내</em>
          <span>대한민국 국적자 : 주민등록증 또는 운전면허증<br />외국인 : 외국인등록증</span>
          <span>대한민국 국적자 : 주민등록증 또는 운전면허증 외국인 : 외국인등록증</span>
          <span>대한민국 국적자 : 주민등록증 또는 운전면허증 외국인 : 외국인등록증 운전면허증 외국인 : 외 운전면허증 외국인 : 외</span>
          -->
        </div>
        <div class="button-box"><a href="#" class="btn regular gray close">닫기</a></div>
      </div>

      <div id="test-button">
        <a href="#" class="btn small blue-line" onclick="enableButton();">다음버튼활성화</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'fail', title: '필수서류 누락', content: '필수 등록 서류를 업로드해주세요.'}, this);">팝업창1</a>
      </div>

    </div>   <!-- #wrapper -->

<script>
'use strict';

// 진행단계 표시
setHeaderStage(4.5);


function enableButton() {
  const btn = document.querySelector('a.btn.blue');
  btn.classList.toggle('disabled');
}






</script>

  </body>
</html>