<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>첨부파일(개인) | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 첨부파일(개인) 페이지" />
  </head>
  <body class="sub file-upload-private">
    <div id="wrapper" class="top-padding">
      
      <%@ include file='../include/header.jsp'; %>
      <%@ include file='../include/header-stage-01.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>

        <h2><span class="before">다우데이타 220-81-01733</span>첨부파일을 업로드해주세요.</h2>

        <section class="content">
          <ul class="file-upload">
            <li>
              <div class="file">
                <span class="label required">
                  <em>사업자 등록증 사본</em>
                  <span class="help">
                    <a href="#"><span>입력도움말</span></a>
                    <span class="popup">
                      <em>※ 사업자 등록증 사본</em>
                      <span>제출일자 기준 2년 이내 발급 서류만 가능<br />사업자등록증명원 제출 시, 3개월 이내 발급 서류 제출</span>
                    </span>
                  </span>
                </span>
                <ul class="file">
                  <li>
                    <span>(주) 다우데이타 사업자 등록증 (주) 다우데이타 사업자 등록증.jpg</span>
                    <a href="#" class="btn small red-line del">삭제</a>
                  </li>
                </ul>
              </div>
              <p><a href="#" class="btn small blue add" title="첨부">추가</a></p>
            </li>
            <li>
              <div class="file">
                <span class="label required">통장 사본
                  <span class="help">
                    <a href="#"><span>입력도움말</span></a>
                    <span class="popup">
                      <em>※ 통장 사본</em>
                      <span>대표자/사업자명의 통장만 가능</span>
                    </span>
                  </span>
                </span>
                <ul class="file">
                  <li>
                    <span>(주) 다우데이타 통장사본.pdf</span>
                    <a href="#" class="btn small red-line del">삭제</a>
                  </li>
                  <li>
                    <span>추가된 통장사본.jpg</span>
                    <a href="#" class="btn small red-line del">삭제</a>
                  </li>
                </ul>
              </div>
              <p><a href="#" class="btn small blue add" title="첨부">추가</a></p>
            </li>
            <li>
              <div class="file">
                <span class="label required">
                  <em>대표자 신분증 사본</em>
                  <span class="help">
                    <a href="#"><span>입력도움말</span></a>
                    <span class="popup">
                      <em>※ 대표자 신분증 사본 안내 (앞/뒷면 모두 제출)</em>
                      <span>운전면허증 및 외국인등록증은 유효기간 이내 신분증 사본 제출</span>
                      <span>대한민국 국적자 : 주민등록번호 뒷자리 중 두번째 숫자부터 삭제한 주민등록증<br />(또는 이와 동일한 운전면허증)</span>
                      <span>외국인 : 외국인등록번호 뒷자리 중 두번째 숫자부터 삭제한 외국인등록증</span>
                    </span>
                  </span>
                </span>
                <ul class="file">
                  <li>
                    <a href="#" class="btn small blue-line add" title="첨부">추가</a>
                  </li>
                </ul>
              </div>
            </li>
            <li>
              <div class="file">
                <span class="label required">
                  <em>개인 인감증명서</em>
                  <span class="help">
                    <a href="#"><span>입력도움말</span></a>
                    <span class="popup">
                      <em>※ 개인 인감증명서</em>
                      <span>- 3개월 이내 발급 서류 제출</span>
                    </span>
                  </span>
                </span>
                <ul class="file">
                  <li>
                    <span>개인 인감증명서.jpg</span>
                    <a href="#" class="btn small red-line del">삭제</a>
                  </li>
                </ul>
              </div>
              <p><a href="#" class="btn small blue add" title="첨부">추가</a></p>
            </li>
            <li>
              <div class="file">
                <span class="label">
                  <em>실제소유자 신분증 사본</em>
                  <span class="help">
                    <a href="#"><span>입력도움말</span></a>
                    <span class="popup">
                      <em>※ 실제소유자 신분증 사본 안내</em>
                      <span>대한민국 국적자 : 주민등록증 또는 운전면허증<br />외국인 : 외국인등록증</span>
                    </span>
                  </span>
                </span>
                <ul class="file">
                  <li>
                    <span>실제소유자 신분증 사본.jpg</span>
                    <a href="#" class="btn small red-line del">삭제</a>
                  </li>
                </ul>
              </div>
              <p><a href="#" class="btn small blue add" title="첨부">추가</a></p>
            </li>
          </ul>

          <div class="button-box">
            <a href="#" class="btn regular blue-line left pc">이전</a>
            <a href="#" class="btn regular blue disabled">다음</a>
          </div>
        </section>
      </main>

      <div class="layer-help mobile">
        <div class="content">
          <!--
          <em>※ 실제소유자 신분증 사본 안내</em>
          <span>대한민국 국적자 : 주민등록증 또는 운전면허증<br />외국인 : 외국인등록증</span>
          <span>대한민국 국적자 : 주민등록증 또는 운전면허증 외국인 : 외국인등록증</span>
          <span>대한민국 국적자 : 주민등록증 또는 운전면허증 외국인 : 외국인등록증 운전면허증 외국인 : 외 운전면허증 외국인 : 외</span>
          -->
        </div>
        <div class="button-box"><a href="#" class="btn regular gray close">닫기</a></div>
      </div>

      <div id="test-button">
        <a href="#" class="btn small blue-line" onclick="enableButton();">다음버튼활성화</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'fail', title: '필수서류 누락', content: '필수 등록 서류를 업로드해주세요.'}, this);">팝업창1</a>
      </div>

    </div>   <!-- #wrapper -->

<script>
'use strict';

// 진행단계 표시
setHeaderStage(4.5);


function enableButton() {
  const btn = document.querySelector('div.button-box > a.btn.blue');
  btn.classList.toggle('disabled');
}






</script>

  </body>
</html>