<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>실제소유자 정보(법인) | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 실제소유자 정보(법인) 페이지" />
  </head>
  <body class="sub owner-corp">
    <div id="wrapper" class="top-padding">
      
      <%@ include file='../include/header.jsp'; %>
      <%@ include file='../include/header-stage-01.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>
        
        <h2><span class="before">다우데이타 220-81-01733</span>실제소유자 정보를 입력해 주세요. (법인)</h2>

        <section class="content">
          <ul class="form two-column">
            <li>
              <label for="corp-type">법인이 속해 있는 유형을 선택해주세요.</label>
              <select name="" id="corp-type">
                <option value="">-- 선택 --</option>
                <option value="">국가/지방자치단체</option>
                <option value="">공공단체/기관</option>
                <option value="">금융회사</option>
                <option value="">상장사 등 사업보고서 제출대상 법인</option>
                <option value="" data-selector=".stock-share">해당없음</option>
              </select>
            </li>
            <li></li>
            <li class="full stock-share">
              <label for="is-shareholder-01">25% 이상의 지분을 보유한 사람이 있나요?</label>
              <ul class="input-list">
                <li><input type="radio" name="is_shareholder" id="is-shareholder-01" value="" data-selector=".real-owner" /><label for="is-shareholder-01">예</label></li>
                <li><input type="radio" name="is_shareholder" id="is-shareholder-02" value="" data-selector=".real-owner, .person-type" /><label for="is-shareholder-02">아니요</label></li>
              </ul>
            </li>
            <li class="full person-type">
              <label for="is-person-01">아래의 유형 중에 해당되는 사람이 있나요?</label>
              <ul class="input-list">
                <li><input type="radio" name="is_person" id="is-person-01" value="" /><label for="is-person-01">최대 지분을 보유한 자</label></li>
                <li><input type="radio" name="is_person" id="is-person-02" value="" /><label for="is-person-02">대표자, 업무진행사원 또는 임원 등의 과반수를 선임한 주주</label></li>
                <li><input type="radio" name="is_person" id="is-person-03" value="" /><label for="is-person-03">법인 또는 단체를 사실상 지배하는 자</label></li>
                <li><input type="radio" name="is_person" id="is-person-04" value="" /><label for="is-person-04">해당 없음 (아래에 법인 또는 단체의 대표자 정보를 입력해주세요.)</label></li>
              </ul>
            </li>
          </ul>
        </section>


        <!-- <h3 class="title stock-share">법인 또는 단체의 대표자 정보를 입력해 주세요.</h3> -->
        <section class="repeat real-owner">
          <h3 class="title">실제소유자 정보</h3>
          <ul class="form two-column">
            <li>
              <div class="form-box">
                <label for="owner-country-1">국적</label>
                <select name="" id="owner-country-1">
                  <option value="">-- 선택 --</option>
                  <option value="">대한민국</option>
                  <option value="">외국인</option>
                </select>
              </div>
            </li>
            <li></li>
            <li>
              <div class="form-box">
                <label for="owner-name-1">실제소유자명</label>
                <input type="text" name="" id="owner-name-1" class="text" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="owner-name-en-1">실제소유자 영문명</label>
                <input type="text" name="" id="owner-name-en-1" class="text" value="" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="owner-birth-date-1">생년월일</label>
                <input type="text" name="" id="owner-birth-date-1" class="text date" placeholder="YYYY-MM-DD" value="" date-format="date" />
              </div>
            </li>
            <li>
              <div class="form-box">
                <label for="owner-share-1">실제소유자 지분율 (지분율이 없는 경우 0 입력)</label>
                <input type="text" name="" id="owner-share-1" class="text percent" value="" />
              </div>
            </li>
          </ul>
        </section>

        <p class="add-section real-owner"><a href="#">실제소유자 정보 추가</a></p>

        <div class="button-box">
          <a href="#" class="btn regular blue-line left pc">이전</a>
          <a href="#" class="btn regular blue disabled">다음</a>
        </div>
      </main>

      <div id="test-button">
        <a href="#" class="btn small blue-line" onclick="enableButton();">다음버튼활성화</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'fail', title: '실제소유자 초과', content: '실제소유자는 최대 3인까지 등록 가능합니다.<br />초과하는 경우, 고객센터로 문의주세요.'}, this);">팝업창1</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'confirm', title: '실제 소유자 삭제 확인', content: '실제소유자 정보 [2] 정보를 삭제할까요?', buttons: ['취소', '삭제']}, this);">팝업창2</a>
      </div>

    </div>   <!-- #wrapper -->

<script>
'use strict';

// 진행단계 표시
setHeaderStage(3.25);


setVisibilityCheck();







// 실 소유자 정보 추가
setAddInfo();
function setAddInfo() {
  const btn = document.querySelector('p.add-section a');
  const firstInfo = document.querySelector('section.repeat');
  const htmlHeader = `
    <div class="header">
      <h4 class="title">실제소유자 추가 1</h4>
      <a href="#" class="btn small red-dash close"><i class="fa-solid fa-minus fa-fw"></i>삭제</a>
    </div>
  `;

  btn.addEventListener('click', function() {
    let copyedHTML = firstInfo.cloneNode(true);
    copyedHTML.insertAdjacentHTML('afterbegin', htmlHeader);
    btn.parentElement.before(copyedHTML);
    resetInfoList();
    setDatePicker({
      container: 'section.real-owner:last-of-type',
      language: 'ko',
      readonly: true
    });

    copyedHTML.querySelector('div.header a.close').addEventListener('click', function() {
      this.closest('section').remove();
      resetInfoList();
    });
  }, false);

  function resetInfoList() {
    const infoList = document.querySelectorAll('section.repeat');
    infoList.forEach(function(info, i) {
      let index = i + 1;
      // 첫번째 리스트는 제외
      if (i > 0) {
        info.querySelector('.title').textContent = '실제소유자 추가 ' + index;
        info.querySelectorAll('[for]').forEach(function(form) {
          let oldText = form.getAttribute('for');
          let newText = oldText.replace(/-\d+$/, '-' + index);
          form.setAttribute('for', newText);
        });
        info.querySelectorAll('[id]').forEach(function(form) {
          let oldText = form.getAttribute('id');
          let newText = oldText.replace(/-\d+$/, '-' + index);
          form.setAttribute('id', newText);
        });
      }
    });
  }
}



function enableButton() {
  const btn = document.querySelector('a.btn.blue');
  btn.classList.toggle('disabled');
}




</script>

  </body>
</html>