<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>실제소유자 정보(개인) | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 실제소유자 정보(개인) 페이지" />
  </head>
  <body class="sub owner-sole">
    <div id="wrapper" class="top-padding">
      
      <%@ include file='../include/header.jsp'; %>
      <%@ include file='../include/header-stage-01.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>

        <h2><span class="before">다우데이타 220-81-01733</span>실제소유자 정보를 입력해 주세요.</h2>

        <ul class="form">
          <li>
            <label for="is-same-01">실제소유자와 대표자가 동일한가요?</label>
            <ul class="input-list">
              <li><input type="radio" name="is_same" id="is-same-01" value="" checked="checked" /><label for="is-same-01">네, 대표자 본인입니다.</label></li>
              <li><input type="radio" name="is_same" id="is-same-02" value="" /><label for="is-same-02">아니요</label></li>
            </ul>
          </li>
        </ul>

        <!--
        <section class="page">
          <ul class="form two-column">
            <li>
              <div class="form-box guide">
                <label for="domestic">내국인 여부 확인</label>
                <select name="" id="domestic">
                  <option value="">-- 선택 --</option>
                  <option value="">내국인</option>
                  <option value="">외국인</option>
                </select>
                <span class="guide">※ 대표자의 내국인 여부를 선택해주세요.</span>
              </div>
            </li>
            <li>
              <div class="form-box guide">
                <label for="regist-id">실명번호</label>
                <input type="text" name="" id="regist-id" class="text" value="" />
                <span class="guide">※ 주민등록번호 / 외국인등록번호 13자리 기재</span>
              </div>
            </li>
          </ul>

          <h3 class="title">대표자 1 실명번호를 입력해주세요.</h3>
          <ul class="form two-column">
            <li>
              <div class="form-box">
                <label for="ceo1-name">대표자명</label>
                <input type="text" name="" id="ceo1-name" class="text" readonly="readonly" value="김다우" />
              </div>
            </li>
            <li></li>
            <li>
              <div class="form-box guide">
                <label for="ceo1-domestic">내국인 여부 확인</label>
                <select name="" id="ceo1-domestic">
                  <option value="">-- 선택 --</option>
                  <option value="">내국인</option>
                  <option value="">외국인</option>
                </select>
                <span class="guide">※ 대표자의 내국인 여부를 선택해주세요.</span>
              </div>
            </li>
            <li>
              <div class="form-box guide">
                <label for="ceo1-regist-id">실명번호</label>
                <input type="text" name="" id="ceo1-regist-id" class="text" value="" />
                <span class="guide">※ 주민등록번호 / 외국인등록번호 13자리 기재</span>
              </div>
            </li>
          </ul>

          <h3 class="title">대표자 2 실명번호를 입력해주세요.</h3>
          <ul class="form two-column">
            <li>
              <div class="form-box">
                <label for="ceo2-name">대표자명</label>
                <input type="text" name="" id="ceo2-name" class="text" readonly="readonly" value="김다우" />
              </div>
            </li>
            <li></li>
            <li>
              <div class="form-box guide">
                <label for="ceo2-domestic">내국인 여부 확인</label>
                <select name="" id="ceo2-domestic">
                  <option value="">-- 선택 --</option>
                  <option value="">내국인</option>
                  <option value="">외국인</option>
                </select>
                <span class="guide">※ 대표자의 내국인 여부를 선택해주세요.</span>
              </div>
            </li>
            <li>
              <div class="form-box guide">
                <label for="ceo2-regist-id">실명번호</label>
                <input type="text" name="" id="ceo2-regist-id" class="text" value="" />
                <span class="guide">※ 주민등록번호 / 외국인등록번호 13자리 기재</span>
              </div>
            </li>
          </ul>
        </section>
      -->

        <section class="page on">
          <section class="repeat">
            <div class="header">
              <h4 class="title">실제소유자 1</h4>
            </div>
            <ul class="form two-column">
              <li>
                <div class="form-box guide">
                  <label for="owner-domestic-1">내국인 여부 확인</label>
                  <select name="" id="owner-domestic-1">
                    <option value="">-- 선택 --</option>
                    <option value="">내국인</option>
                    <option value="">외국인</option>
                  </select>
                  <span class="guide">※ 대표자의 내국인 여부를 선택해주세요.</span>
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="owner-name-en-1">실제소유자 영문명</label>
                  <input type="text" name="" id="owner-name-en-1" class="text" value="" />
                </div>
              </li>
              <li>
                <div class="form-box">
                  <label for="owner-name-1">실제소유자명</label>
                  <input type="text" name="" id="owner-name-1" class="text" value="" />
                </div>
              </li>
              <li>
                <div class="form-box guide">
                  <label for="owner-regist-id-1">실명번호</label>
                  <input type="text" name="" id="owner-regist-id-1" class="text" value="" />
                  <span class="guide">※ 주민등록번호 / 외국인등록번호 13자리 기재</span>
                </div>
              </li>
              <li>
                <div class="form-box full">
                  <label for="owner-nation-1">국적</label>
                  <select name="" id="owner-nation-1">
                    <option value="">-- 선택 --</option>
                    <option value="">대한민국</option>
                    <option value="">미국</option>
                  </select>
                </div>
              </li>
            </ul>
          </section>


          <p class="add-section"><a href="#">실제소유자 정보 추가</a></p>
        </section>

        <div class="button-box">
          <a href="#" class="btn regular blue-line left pc">이전</a>
          <a href="#" class="btn regular blue disabled">다음</a>
        </div>
      </main>

      <div id="test-button">
        <a href="#" class="btn small blue-line" onclick="enableButton();">다음버튼활성화</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'fail', title: '실제소유자 초과', content: '실제소유자는 최대 3인까지 등록 가능합니다.<br />초과하는 경우, 고객센터로 문의주세요.'}, this);">팝업창1</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'confirm', title: '실제 소유자 삭제 확인', content: '실제소유자 정보 [2] 정보를 삭제할까요?', buttons: ['취소', '삭제']}, this);">팝업창2</a>
      </div>

    </div>   <!-- #wrapper -->

<script>
'use strict';

// 진행단계 표시
setHeaderStage(3.25);



/*
// 대표자/실소유자 정보 선택
setOwnerType();
document.querySelectorAll('[name="is_same"]').forEach(function(radio) {
  radio.addEventListener('change', function() {
    setOwnerType();
  }, false);
});

function setOwnerType() {
  const pages = document.querySelectorAll('section.page');

  document.querySelectorAll('[name="is_same"]').forEach(function(radio, i) {
    if (radio.checked === true) {
      pages[i].classList.add('on');
    } else {
      pages[i].classList.remove('on');
    }
  });
}
*/



// 실 소유자 정보 추가
setAddInfo();
function setAddInfo() {
  const btn = document.querySelector('p.add-section a');
  const firstInfo = document.querySelector('section.repeat:nth-of-type(1)');
  const delBtn = `<a href="#" class="btn small red-dash close"><i class="fa-solid fa-minus fa-fw"></i>삭제</a>`;

  btn.addEventListener('click', function() {
    let copyedHTML = firstInfo.cloneNode(true);
    copyedHTML.querySelector('div.header').insertAdjacentHTML('afterbegin', delBtn);
    btn.parentElement.before(copyedHTML);
    resetInfoList();

    copyedHTML.querySelector('div.header a.close').addEventListener('click', function() {
      this.closest('section').remove();
      resetInfoList();
    });
  }, false);

  function resetInfoList() {
    const infoList = document.querySelectorAll('section.repeat');
    infoList.forEach(function(info, i) {
      let index = i + 1;
      // 첫번째 리스트는 제외
      if (i > 0) {
        info.querySelector('.title').textContent = '실제소유자 ' + index;
        info.querySelectorAll('[for]').forEach(function(form) {
          let oldText = form.getAttribute('for');
          let newText = oldText.replace(/-\d+$/, '-' + index);
          form.setAttribute('for', newText);
        });
        info.querySelectorAll('[id]').forEach(function(form) {
          let oldText = form.getAttribute('id');
          let newText = oldText.replace(/-\d+$/, '-' + index);
          form.setAttribute('id', newText);
        });
      }
    });
  }
}



function enableButton() {
  const btn = document.querySelector('a.btn.blue');
  btn.classList.toggle('disabled');
}




</script>

  </body>
</html>