<!DOCTYPE html>
<html lang="ko">
  <head>
    <%@ include file='../include/head.jsp'; %>
    <title>결제수단 | 키움페이 전자계약</title>
    <meta name="description" content="키움페이 전자계약 결제수단 페이지" />
  </head>
  <body class="sub payment-method">
    <div id="wrapper" class="top-padding">
      
      <%@ include file='../include/header.jsp'; %>
      <%@ include file='../include/header-stage-01.jsp'; %>

      <main id="main">
        <a href="#" id="main-start">본문시작</a>

        <h2><span class="before">다우데이타 220-81-01733</span>사용하실 결제수단을 선택해주세요.</h2>

        <section class="content">
          <ul class="form tall">
            <li>
              <span class="label">기본 결제수단</span>
              <ul class="input-box">
                <li><input type="checkbox" name="" id="payment-method-01" checked="checked" value="" data-type="fixed" /><label for="payment-method-01">신용카드</label></li>
                <li><input type="checkbox" name="" id="payment-method-02" checked="checked" value="" data-type="fixed" /><label for="payment-method-02">가상계좌</label></li>
                <li><input type="checkbox" name="" id="payment-method-03" checked="checked" value="" data-type="fixed" /><label for="payment-method-03">계좌이체</label></li>
                <li><input type="checkbox" name="" id="payment-method-04" checked="checked" value="" data-type="fixed" /><label for="payment-method-04">삼성페이</label></li>
                <li><input type="checkbox" name="" id="payment-method-05" checked="checked" value="" data-type="fixed" /><label for="payment-method-05">네이버페이</label></li>
                <li><input type="checkbox" name="" id="payment-method-06" checked="checked" value="" data-type="fixed" /><label for="payment-method-06">카카오페이</label></li>
                <li><input type="checkbox" name="" id="payment-method-07" checked="checked" value="" data-type="fixed" /><label for="payment-method-07">페이코</label></li>
              </ul>
            </li>
            <li>
              <span class="label">부가 결제수단 (선택)<span>* 기본 결제 패키지 선택 시, 자유롭게 추가하실 수 있습니다.</span></span>
              <ul class="input-list column2">
                <li><input type="checkbox" name="" id="sub-method-01" value="" /><label for="sub-method-01">휴대폰결제</label></li>
                <li><input type="checkbox" name="" id="sub-method-02" value="" /><label for="sub-method-02">문화상품권</label></li>
                <li><input type="checkbox" name="" id="sub-method-03" value="" /><label for="sub-method-03">티머니</label></li>
                <li><input type="checkbox" name="" id="sub-method-04" value="" /><label for="sub-method-04">게임문화상품권</label></li>
                <li><input type="checkbox" name="" id="sub-method-05" value="" /><label for="sub-method-05">폰빌</label></li>
                <li><input type="checkbox" name="" id="sub-method-06" value="" /><label for="sub-method-06">도서문화상품권</label></li>
                <li><input type="checkbox" name="" id="sub-method-07" value="" /><label for="sub-method-07">모바일팝</label></li>
                <li><input type="checkbox" name="" id="sub-method-08" value="" /><label for="sub-method-08">해피머니 문화상품권</label></li>
                <li><input type="checkbox" name="" id="sub-method-09" value="" /><label for="sub-method-09">에그머니상품권</label></li>
              </ul>
            </li>
            <li>
              <ul class="input-list">
                <li class="title"><input type="checkbox" name="" id="reg-agree-all" value="" /><label for="reg-agree-all">모든 이용약관을 확인하였으며 이에 동의합니다.</label></li>
                <li><input type="checkbox" name="" id="reg-agree-01" value="" /><label for="reg-agree-01">[필수] 전자결제 서비스 이용동의</label></li>
                <li><input type="checkbox" name="" id="reg-agree-02" value="" /><label for="reg-agree-02">[필수] 개인정보 수집, 이용 및 제공 동의</label></li>
              </ul>
            </li>
          </ul>

          <div class="button-box">
            <a href="#" class="btn regular blue-line left pc">이전</a>
            <a href="#" class="btn regular blue disabled">다음</a>
          </div>
        </section>
      </main>

      <div id="test-button">
        <a href="#" class="btn small blue-line" onclick="enableButton();">다음버튼활성화</a>
        <a href="#" class="btn small blue-line" onclick="showLayerPopup('#layer-payment', this);">팝업창1</a>
        <a href="#" class="btn small blue-line" onclick="displayPopup({type: 'confirm', title: 'ID 확인', content: '다음 단계로 넘어가시는 경우,<br />로그인한 ID로만 제출할 수 있습니다.<br />진행하시겠습니까?'}, this);">팝업창2</a>
        <a href="#" class="btn small blue-line" onclick="showLayerPopup('#layer-regulation', this);">팝업창3</a>
      </div>

    </div>   <!-- #wrapper -->

    <div id="layer-payment">
      <div class="container">
        <div class="header pc">
          <div class="info">
            <em>Information</em>
            <p>중소 사업자의 경우 우대수수료를 적용 받을 수 있으며,<br />영업담당자 수수료 협의 단계에서 일부 변동될 수 있습니다.</p>
          </div>
        </div>
        <table class="payment-info">
          <caption>결제수단별 수수료 목록</caption>
          <thead>
            <tr>
              <th>결제수단</th>
              <th>수수료 (VAT 별도)</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td>신용카드</td>
              <td>3.20%</td>
            </tr>
            <tr>
              <td>계좌이체</td>
              <td>2.00% (1만원 이하 200원)</td>
            </tr>
            <tr>
              <td>가상계좌</td>
              <td>250원</td>
            </tr>
            <tr>
              <td>네이버페이</td>
              <td>3.20%</td>
            </tr>
            <tr>
              <td>카카오페이</td>
              <td>3.20%</td>
            </tr>
            <tr>
              <td>페이코</td>
              <td>3.20%</td>
            </tr>
            <tr>
              <td>삼성페이</td>
              <td>3.20%</td>
            </tr>
            <tr>
              <td>상품권결제</td>
              <td>9.00%</td>
            </tr>
            <tr>
              <td>휴대폰(실물)</td>
              <td>3.50%</td>
            </tr>
            <tr>
              <td>휴대폰(디지털/컨텐츠)</td>
              <td>6.50%</td>
            </tr>
          </tbody>
        </table>
      </div>
      <div class="button-box center"><a href="#" class="btn small blue-line close">닫기</a></div>
    </div>


    <div id="layer-regulation">
      <div class="container">
        <h3>개인정보 수집 및 이용동의</h3>
        <p>다우데이타(이하 회사라 함)는 "신용정보의 이용 및 보호에 관한 법률", "전자금융거래법", "전자상거래 등에서의 소비자보호에 관한 법률", "정보통신망 이용촉진 및 정보보호 등에 관한 법률" 및 "개인정보 보호법" 등 관련 법령을 준수하여, 이용자 권익 보호에 최선을 다하고 있습니다.</p>
        
        <h4>1. 개인정보의 수집·이용 목적</h4>
        <p>홈페이지 서비스 이용을 위한 사용자 식별 및 가맹점 정보 접근권한 관리<br />홈페이지 이용에 대한 문의 및 불만사항 접수, 회신<br />홈페이지 이용빈도 파악 및 통계 활용 ※ 회사는 개인정보를 위의 목적으로 처리하며, 동의받은 목적 이외의 용도로 처리하지 않습니다.</p>
        <h4>2. 수집·이용하는 개인정보 항목</h4>
        <p>성명, 이메일주소, 비밀번호, 휴대폰번호</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
        <h4>3. 개인정보의 보유 및 이용기간</h4>
        <p>회원 탈퇴(계정 삭제) 시 까지<br />원칙적으로 개인정보의 수집·이용 목적이 달성되면 지체 없이 파기합니다. 단, 관련 법령의 규정 또는 회사 내부 방침에 의하여 보존할 필요가</p>
      </div>
      <p class="button"><a href="#" class="close">닫기</a></p>
    </div>

<script>
'use strict';

// 진행단계 표시
setHeaderStage(1);

// 모두 체크 UI
setCheckList();

function setCheckList() {
  const allChecks = document.querySelectorAll('ul.input-list > li.title input[type="checkbox"]');
  allChecks.forEach(function(allCheck) {
    const container = allCheck.closest('ul');
    const checks = container.querySelectorAll('li:not(.title) > input[type="checkbox"]');

    setCheckboxStatus();
    setCheckboxStatus2();

    allCheck.addEventListener('change', function() {
      setCheckboxStatus();
    }, false);

    checks.forEach(function(check) {
      check.addEventListener('change', function() {
        setCheckboxStatus2();
      }, false);
    });


    function setCheckboxStatus() {
      if (allCheck.checked === true) {
        checks.forEach(function(check) {
          check.checked = true;
        });
      } else {
        checks.forEach(function(check) {
          check.checked = false;
        });
      }
    }

    function setCheckboxStatus2() {
      let numChecks = checks.length;
      let numChecked = 0;

      checks.forEach(function(check) {
        if (check.checked === true) numChecked++;
      }, false);
      if (numChecks === numChecked) {
        allCheck.checked = true;
      } else {
        allCheck.checked = false;
      }
    }

  });
}

// checkbox 고정 (수정 불가)
setCheckboxFixed();
function setCheckboxFixed() {
  const checks = document.querySelectorAll('input[type="checkbox"][data-type="fixed"]');
  checks.forEach(function(check) {
    check.addEventListener('click', function(e) {
      e.preventDefault();
    }, false);
  });
}


function enableButton() {
  const btn = document.querySelector('a.btn.blue');
  btn.classList.toggle('disabled');
}


</script>

  </body>
</html>